RCS file: RCS/ufs_syscalls.c,v
retrieving revision 1.1
diff -c2 -r1.1 ufs_syscalls.c
*** ufs_syscalls.r1_1	Tue Jun 25 18:34:36 1985
--- ufs_syscalls.c	Tue Jun 25 18:33:05 1985
***************
*** 1049,1052
  		mode |= IFREG;
  	ip->i_mode = mode & ~u.u_cmask;
  	ip->i_nlink = 1;
  	ip->i_uid = u.u_uid;

--- 1049,1059 -----
  		mode |= IFREG;
  	ip->i_mode = mode & ~u.u_cmask;
+ 	/*
+ 	 * clear the acl.  there should be a default acl (besides a null one).
+ 	 * there is no room to put a default acl in the parent directory's
+ 	 * inode;  so the alternative is to put a default acl in the u area
+ 	 * (which is where the umask is).
+ 	 */
+ 	null_acle( ip, 0 );
  	ip->i_nlink = 1;
  	ip->i_uid = u.u_uid;
***************
*** 1126,1129
  	ip->i_flag |= IACC|IUPD|ICHG;
  	ip->i_mode = uap->dmode & ~u.u_cmask;
  	ip->i_nlink = 2;
  	ip->i_uid = u.u_uid;

--- 1133,1143 -----
  	ip->i_flag |= IACC|IUPD|ICHG;
  	ip->i_mode = uap->dmode & ~u.u_cmask;
+ 	/*
+ 	 * clear the acl.  there should be a default acl (besides a null one).
+ 	 * a good default for a directory might be to copy the parent
+ 	 * directory's acl.  or put a default directory acl alongside the
+ 	 * default file acl (wherever that ends up).
+ 	 */
+ 	null_acle( ip, 0 );
  	ip->i_nlink = 2;
  	ip->i_uid = u.u_uid;

# there are some changes to the access() routine, just because it made
# it more readable for me, that have nothing to do with acls.  like
# changing the "m" variable to "mode_desire".

RCS file: RCS/ufs_fio.c,v
retrieving revision 1.1
diff -c2 -r1.1 ufs_fio.c
*** ufs_fio.c.r1_1	Tue Jun 25 18:47:49 1985
--- ufs_fio.c	Tue Jun 25 18:45:33 1985
***************
*** 17,20
  #include "../h/proc.h"
  #include "../h/nami.h"
  
  /*

--- 17,21 -----
  #include "../h/proc.h"
  #include "../h/nami.h"
+ #include "../h/acl.h"
  
  /*
***************
*** 31,35
   * permissions.
   */
! access(ip, mode)
  	register struct inode *ip;
  	int mode;

--- 32,36 -----
   * permissions.
   */
! access(ip, mode_desire)
  	register struct inode *ip;
  	int mode_desire;
***************
*** 33,37
  access(ip, mode)
  	register struct inode *ip;
! 	int mode;
  {
  	register m;

--- 34,38 -----
  access(ip, mode_desire)
  	register struct inode *ip;
! 	int mode_desire;
  {
  	register int i;
***************
*** 35,40
  	int mode;
  {
! 	register m;
! 	register int *gp;
  
  	m = mode;

--- 36,43 -----
  	int mode_desire;
  {
! 	register int i;
! 	int id_match;
! 	int mode_allow;
! 	int *gp;
  
  	if (mode_desire == IWRITE) {
***************
*** 38,43
  	register int *gp;
  
! 	m = mode;
! 	if (m == IWRITE) {
  		/*
  		 * Disallow write attempts on read-only

--- 41,45 -----
  	int *gp;
  
! 	if (mode_desire == IWRITE) {
  		/*
  		 * Disallow write attempts on read-only
***************
*** 78,92
  	 * check public access.
  	 */
! 	if (u.u_uid != ip->i_uid) {
! 		m >>= 3;
! 		if (u.u_gid == ip->i_gid)
! 			goto found;
! 		gp = u.u_groups;
! 		for (; gp < &u.u_groups[NGROUPS] && *gp != NOGROUP; gp++)
! 			if (ip->i_gid == *gp)
! 				goto found;
! 		m >>= 3;
! found:
! 		;
  	}
  	if ((ip->i_mode&m) != 0)

--- 80,100 -----
  	 * check public access.
  	 */
! 	id_match = 0;
! 	/*
! 	 * user access (1) - match effective uid against fileowner uid.
! 	 * user access (2) - match group list against fileowner uid.
! 	 */
! 	if (u.u_uid == ip->i_uid) {
! 		id_match++;
! 		mode_allow = ip->i_mode;
! 	} else {
! 		for( i = 0; i < MAXACL && ok_acle(ip,i); i++ ) {
! 			if ( ( acle_type(ip,i) == A_USER ) &&
! 				( u.u_uid == acle_id(ip,i) ) ) {
! 				id_match++;
! 				mode_allow = acle_mode(ip,i) << 6;
! 				break;
! 			}
! 		}
  	}
  		
***************
*** 90,94
  		;
  	}
! 	if ((ip->i_mode&m) != 0)
  		return (0);
  	u.u_error = EACCES;

--- 98,158 -----
  		}
  	}
! 		
! 	/*
! 	 * group access (1) - match effective gid against acl.
! 	 */
! 	if ( ! id_match ) {
! 		mode_desire >>= 3;
! 		for( i = 0; i < MAXACL && ok_acle(ip,i); i++ ) {
! 			if ( ( acle_type(ip,i) == A_GROUP ) &&
! 				( u.u_gid == acle_id(ip,i) ) ) {
! 				id_match++;
! 				mode_allow = acle_mode(ip,i) << 3;
! 				break;
! 			}
! 		}
! 	}
! 		
! 	/*
! 	 * group access (2) - match group list against acl.
! 	 */
! 	if ( ! id_match ) {
! 		for (gp = u.u_groups; gp < &u.u_groups[NGROUPS] && *gp != NOGROUP; gp++)
! 			for( i = 0; i < MAXACL && ok_acle(ip,i); i++ ) {
! 				if ( ( acle_type(ip,i) == A_GROUP ) &&
! 					( *gp == acle_id(ip,i) ) ) {
! 					id_match++;
! 					mode_allow = acle_mode(ip,i) << 3;
! 					break;
! 				}
! 			}
! 	}
! 		
! 	/*
! 	 * group access (3) - match effective gid against fileowner gid.
! 	 * group access (4) - match group list against fileowner gid.
! 	 */
! 	if ( ! id_match ) {
! 		if ( u.u_gid == ip->i_gid ) {
! 			id_match++;
! 			mode_allow = ip->i_mode;
! 		} else {
! 			for (gp = u.u_groups; gp < &u.u_groups[NGROUPS] && *gp != NOGROUP; gp++)
! 				if (ip->i_gid == *gp) {
! 					id_match++;
! 					mode_allow = ip->i_mode;
! 					break;
! 				}
! 		}
! 	}
! 
! 	/*
! 	 * other access.
! 	 */
! 	if ( ! id_match ) {
! 		mode_desire >>= 3;
! 		mode_allow = ip->i_mode;
! 	}
! 	if ((mode_allow&mode_desire) != 0)
  		return (0);
  	u.u_error = EACCES;
