#include <stdio.h>
#include <sys/param.h>
#include <sys/acl.h>
#include <grp.h>
#include <pwd.h>

main(argc, argv, environ)
int argc;
char *argv[], *environ[];
{
	int i, j, na;
	struct acle acl[MAXACL];
	int status;

	status = 0;

	for ( i = 1; i < argc; i++ ) {
		na = getacl( argv[i], MAXACL, acl );

		if ( na < 0 ) {
			perror( argv[i] );
			status++;

		} else {
			printf( "%s\n", argv[i] );

			for ( j = 0; j < na; j++ ) {
				int type = acl[j].a_type;
				int id = acl[j].a_id;
				int mode = acl[j].a_mode;

				if ( type == A_USER ) {
					struct passwd *up = getpwuid(id);

					if ( up == NULL ) {
						printf( "\tuser\t[uid %d]\t%d\n", id, mode );
					} else {
						printf( "\tuser\t%s\t%d\n", up->pw_name, mode );
					}

				} else {
					struct group *gp = getgrgid(id);

					if ( gp == NULL ) {
						printf( "\tgroup\t[gid %d]\t%d\n", id, mode );
					} else {
						printf( "\tgroup\t%s\t%d\n", gp->gr_name, mode );
					}
				}
			}
		}
	}

	exit( status );
}
