#! /bin/csh -f

set path = ( /usr/new /usr/local /usr/ucb /usr/bin /bin . )
setenv PATH  /usr/new:/usr/local:/usr/ucb:/usr/bin:/bin:.
unset noclobber
set noglob

set DEF_ED = /usr/ucb/vi
# WS == WhiteSpace ; WF == WordForming ; NF == NumberForming .
set WS = "[ 	][ 	]*"
set WSO = "[ 	]*"
set WF = "[a-zA-Z][a-zA-Z0-9]*"
set NF = "[0-9][0-9]*"

foreach i ( $argv[*]:q )
	set acl_file = "/tmp/edacl_${i:t}_$$"
	lsacl "$i" > "$acl_file"

	if ( $status == 0 ) then
		set state = edit
		while 1
			switch ( $state )
			case edit :
				if ( ! $?EDITOR ) then
					echo -n "edacl: editor [$DEF_ED] : "
					set EDITOR = $<
					if ( "_$EDITOR" == "_" ) set EDITOR = $DEF_ED
				endif

				/bin/sh -c "$EDITOR '$acl_file'"

				if ( $status == 0 ) then
					set state = prompt
				else
					unset EDITOR
					unsetenv EDITOR
				endif

				breaksw

			case prompt :
				echo -n edacl: update acl for "$i" "? [yne] "
				set response = $<

				if ( "_$response" == "_" || "_$response" =~ _y* ) then
					set state = update
				else if ( "_$response" =~ _e* ) then
					set state = edit
				else if ( "_$response" =~ _n* ) then
					set state = noupdate
				else
					echo "Yes - update acl;  No - opposite of Yes;  Edit - try again."
				endif

				breaksw

			case update :
				chacl `sed -e 1d -e '2,$'"s/^${WSO}user\(${WS}${WF}${WS}${NF}\)/-u \1/" -e '2,$'"s/^${WSO}group\(${WS}${WF}${WS}${NF}\)/-g \1/" "$acl_file"` -f "$i"

				break

			case noupdate :

				break

			default :
				echo "edacl: internal error (in switch statement).  HELP"

				breaksw

			endsw
		end

		rm -f "$acl_file"
	endif
end
