#include <stdio.h>
#include <sys/param.h>
#include <sys/acl.h>

/*
 * cpacl : copy the access control list of one file to other files.
 *
 * usage : cpacl fromfile tofile [tofile ...]
 */
main(argc, argv, environ)
int argc;
char *argv[], *environ[];
{
	int i;
	struct acle acl[MAXACL];
	int status;
	int na;

	status = 0;

	if ( argc > 1 ) {
		if ( (na = getacl(argv[1],MAXACL,acl)) != -1 ) {
			for ( i = 2; i < argc; i++ ) {
				if ( setacl( argv[i], na, acl ) != 0 ) {
					perror( argv[i] );
					status++;
				}
			}
		} else {
			perror( argv[1] );
			status++;
		}
	} else {
		fprintf( stderr, "cpacl: usage: cpacl fromfile tofile [tofile ...]\n" );
	}

	exit( status );
}
