''' $Header:$
''' 
''' $Log:$
.de Sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.ie n \{\
.tr \(bs-\*(Tr
.ds -- \(bs-
.if (\n(.H=4u)&(1m=24u) .ds -- \(bs\h'-12u'\(bs\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(bs\h'-12u'\(bs\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
'br\}
.TH chacl 1 LOCAL
.SH NAME
chacl - change the access control list for files
.SH SYNOPSIS
.B chacl
[-u username mode ...] [-g groupname mode ...] -f file ...
.SH DESCRIPTION
.I chacl
changes the access control lists for one or more files.  The
access control list (or acl) and the file's ownership are used to determine
which users can access the file.
.PP
The
.B \-u
option marks the beginning of a list of "username mode" pairs.
Similarly, the
.B \-g
option marks the beginning of a list of "groupname mode" pairs.
A "name mode" pair is referred to as an "acl entry".
The
.B \-f
option separates the acl from the list of files involved.
.PP
The username or groupname is hunted for in the first field of /etc/passwd
or /etc/group , respectively.
The mode is a single digit in the range [0-7] indicating read-write-execute
permission ala
.IR chmod .
.PP
The current implementation allows up to 8 acl entries.  This is defined
by the constant MAXACL in <sys/acl.h>.  An entry cannot deny access
to the superuser.
Setting a file's acl removes any existing acl entries (i.e., calls to
.I chacl
do not accumulate).  Only the owner of a file (or the superuser) can
change its acl.
.PP
Access decisions are made in the following way.
.Sp
	If the effective userid (euid) is the superuser, grant access.
.Sp
	Else if the euid is the file's owning uid, check the owner permission.
.Sp
	Else if the euid matches an acl entry,
check the entry's mode.
.Sp
	Else if the effective groupid (egid) matches an acl entry,
check the entry's mode.
.Sp
	Else if some member of the group list matches an acl entry,
check the entry's mode.
.Sp
	Else if the egid is the file's owning gid, check the group permission.
.Sp
	Else if some member of the group list matches the file's owning gid,
check the group permission.
.Sp
	Else check the other permission.
.PP
Order within the acl is important.  When matching against the acl, entries
are checked in order, stopping at the first match.  (Multiple matches could
only occur in group acl entries.)
.SH EXAMPLES
	chacl -u jjg 7 -g d75 0 -f gossip
.Sp
grants full access to the file "gossip" to the user "jjg", and denies all
access to this file to the group "d75".
.Sp
	chacl -f rumors
.Sp
resets the acl for the file "rumors".
.Sp
	chacl -u jjg 6 uucp 4 -f facts
.Sp
grants read-write access to the user "jjg" and read access to the user
"uucp" for the file "facts".
.SH DIAGNOSTICS
Various messages indicate syntactic errors in the command line arguments.
Minor errors are flagged with a "warning:", and indicate that
.I chacl
carried on and set the access control lists for the files.
.PP
.I chacl
returns with exit status 0 if all is well;  with exit status 1 if there
are errors in the command line arguments;  or with exit status greater
than 0 if the acls for some files could not be set.
.SH SEE ALSO
cpacl(1),
edacl(1),
lsacl(1),
getacl(2),
setacl(2)
.SH CAVEAT
The implementation of access control lists is an experiment.  This
implementation stores the access control list in a (formerly) unused field
in the inode.
There is no guarantee that future versions of Unix will not use this field
for something else.
.PP
Therefore, you should only use access control lists with the full
understanding that you are participating in an experiment.
.SH BUGS
Allowing wildcards in the acl entry's name would be useful.
