/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_unit.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */
/*
 * Joe Dellinger Oct 19, 1987 (Monday Massacre)
 * Put in ifdef's for 4.2 VS 4.3.
 * Somebody should volunteer to re-write this routine in FORTRAN.
 * Phil Farrell 31 Dec 1987
 *   changed 4.3 ifdef identfier from "4.3BSD", which is illegal in
 *   C because it contains a period and numerals, to FOURTHREEBSD
 */

#ifdef FORTRAN
#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

/*
 * fortran logical unit table definitions
 */
typedef long    ftnint;
typedef ftnint  flag;

typedef struct		/*units*/
{
    FILE           *ufd;/*0=unconnected*/
    char           *ufnm;
    long            uinode;
    int             url;/*0=sequential*/
    flag            useek;	/*true=can backspace, use dir, ...*/
    flag            ufmt;
    flag            uprnt;
    flag            ublnk;
    flag            uend;
    flag            uwrt;	/*last io was write*/
    flag            uscrtch;
}               unit;

extern unit     units[];/*logical units table*/
vpunit_ (lunit)
    long           *lunit;
{
FILE           *fileptr;
unit           *uptr;

    uptr = units + (*lunit);
    fileptr = uptr->ufd;
/*
 * A low-level routine from the fortran compiler library is called
 * here to determine if file is accessed.  This routine has a different
 * name under 4.2BSD than 4.3BSD.
 */
#ifdef FOURTHREEBSD
    nowwriting (uptr);
#else
    now_acc (uptr, "a");
#endif
    vp_pc._pltout = fileptr;
}
#endif
