/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_text.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 *
 * Joe Dellinger Oct 17 1987
 *	Made Fortran and C calling arguments match.
 *
 * Joe Dellinger Dec 7 1987
 *	Transferred handling of the text justification and font
 *	to the routines where you'd expect that to get handled,
 *	instead of only updating that when this routine is called.
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define TEXT	vpwtext_
#define X		*x
#define Y		*y
#define SIZE	*size
#define ORIENT	*orient

#else

#define TEXT	vp_text
#define X		x
#define Y		y
#define SIZE	size
#define ORIENT	orient

#endif

#ifdef FORTRAN
TEXT (x, y, size, orient, string, nchars)
#else
TEXT (x, y, size, orient, string)
#endif
    float           X, Y;
    int             SIZE, ORIENT;
    char           *string;
#ifdef FORTRAN
    int            *nchars;
#endif
{
#ifdef FORTRAN
int             i, length;
#endif

    if (SIZE == 0)
	return;

    p_pout (X, Y, 0, vp_pc._pltout);
    putc (VP_TEXT, vp_pc._pltout);
    puth (SIZE, vp_pc._pltout);
    puth (ORIENT, vp_pc._pltout);

#ifdef FORTRAN
/*
 * Try to still work even if they didn't specify nchars.
 */
    length = 80;
    if (nchars != NULL)
    {
	if (*nchars >= 0)
	    length = *nchars;
    }

    for (i = 0; i < length; i++)
    {
	if (*(string + i) == '\0')
	    break;
	putc (*(string + i), vp_pc._pltout);
    }
    putc ('\0', vp_pc._pltout);
#else FORTRAN
    do
    {
	putc (*string, vp_pc._pltout);
    }
    while (*string++);
#endif FORTRAN
}
