/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_setdash.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding.
 */

#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#define SETDASH	vpsetdash_
#define LP		*lp
#define DASHP dashp2
#define GAPP gapp2

#else

#define SETDASH	vp_setdash
#define LP		lp
#define DASHP dashp
#define GAPP gapp

#endif

SETDASH (dashp, gapp, lp)
    float          *dashp, *gapp;
    int             LP;
{
int             i;
int             ix, iy;

#ifdef FORTRAN
register float *dashp2, *gapp2;
    dashp2 = dashp;
    gapp2 = gapp;
#endif FORTRAN

    putc (VP_SETDASH, vp_pc._pltout);
    puth (LP, vp_pc._pltout);
    for (i = 0; i < LP; i++)
    {
	ix = ROUND ((*DASHP) * RPERIN);
	iy = ROUND ((*GAPP) * RPERIN);
	DASHP++;
	GAPP++;
	puth (ix, vp_pc._pltout);
	puth (iy, vp_pc._pltout);
    }
}
