/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_raster.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding.
 */

/* This program cannot be indented! */

#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#define RASTER		vpraster_
#define XLL		*xll
#define YLL		*yll
#define XPIX		*xpix
#define YPIX		*ypix
#define PPI		*ppi
#define	BIT		*bit
#define OFFSET		*offset
#define	BLAST		*blast
#define	ORIENT		*orient
#define	INVERT		*invert

#else

#define RASTER		vp_raster
#define XLL		xll
#define YLL		yll
#define XPIX		xpix
#define YPIX		ypix
#define PPI		ppi
#define	BIT		bit
#define OFFSET		offset
#define	BLAST		blast
#define	ORIENT		orient
#define	INVERT		invert

#endif

#define ARRAY(A,B)	array[(((INVERT)==0)?(A):(YPIX-1-(A)))*(XPIX)+(B)]

#define MAXREP	8
#define PUTHSIZE sizeof(int)

#define RASOUT(NUMPAT,NUMBYTE,BITFLAG,BYTES)	\
{\
    puth ((int) (NUMPAT), vp_pc._pltout);\
    puth ((int) (NUMBYTE), vp_pc._pltout);\
\
    if (BITFLAG)\
    {\
	for (nn = 0; nn + 7 < (NUMBYTE); nn += 8)\
	{\
	    obyte = 0x00;\
\
	    obyte =\
		((*((BYTES) + nn + 0) != 0) << 7) |\
		((*((BYTES) + nn + 1) != 0) << 6) |\
		((*((BYTES) + nn + 2) != 0) << 5) |\
		((*((BYTES) + nn + 3) != 0) << 4) |\
		((*((BYTES) + nn + 4) != 0) << 3) |\
		((*((BYTES) + nn + 5) != 0) << 2) |\
		((*((BYTES) + nn + 6) != 0) << 1) |\
		((*((BYTES) + nn + 7) != 0) << 0);\
	    putc ((char) obyte, vp_pc._pltout);\
	}\
	if (nn < (NUMBYTE))\
	{\
	    obyte = 0x00;\
	    for (nnn = 7; nn < (NUMBYTE); nn++, nnn--)\
	    {\
		obyte |= ((*((BYTES) + nn) != 0) << nnn);\
	    }\
	    putc ((char) obyte, vp_pc._pltout);\
	}\
    }\
    else\
    {\
	for (nn = 0; nn < (NUMBYTE); nn++)\
	{\
	    putc ((char) * ((BYTES) + nn), vp_pc._pltout);\
	}\
    }\
}

RASTER (array, blast, bit, offset, xpix, ypix, xll, yll, ppi, xur, yur, orient, invert)
unsigned char  *array;
float   XLL, YLL, *xur, *yur, PPI;
int     XPIX, YPIX, BIT, OFFSET, BLAST, ORIENT, INVERT;
{
    int     mm, nn, nnn, ll, kk, jj, ii, count, ucount, bitbyte;
    int     ix, iy;
    unsigned char   obyte;

    if (BIT)
    {
	bitbyte = 8;
	putc (VP_BIT_RASTER, vp_pc._pltout);
    }
    else
    {
	bitbyte = 1;
	putc (VP_BYTE_RASTER, vp_pc._pltout);
    }

    if (ORIENT >= 0)
	ORIENT = ORIENT % 4;
    else
	ORIENT = ((ORIENT % 4) + 4) % 4;

    puth ((int) ORIENT, vp_pc._pltout);
    puth ((int) offset, vp_pc._pltout);
    ix = ROUND (XLL * RPERIN);
    iy = ROUND (YLL * RPERIN);
    puth (ix, vp_pc._pltout);
    puth (iy, vp_pc._pltout);
    if (PPI > 0)
    {
	ix += ROUND (RPERIN * XPIX / PPI);
	iy += ROUND (RPERIN * YPIX / PPI);
	*xur = ix / (float) RPERIN;
	*yur = iy / (float) RPERIN;
    }
    else
    {
	ix = ROUND (*xur * RPERIN);
	iy = ROUND (*yur * RPERIN);
    }
    puth (ix, vp_pc._pltout);
    puth (iy, vp_pc._pltout);

    puth ((int) XPIX, vp_pc._pltout);
    puth ((int) YPIX, vp_pc._pltout);

    if (BLAST)
    {
/* Don't try to compact it at all */
	for (ii = 0; ii < YPIX; ii++)
	{
	    puth ((int) 1, vp_pc._pltout);
	    RASOUT (1, XPIX, BIT, &ARRAY (ii, 0));
	}
    }
    else
    {
/* Try to compact it */
	count = 1;
	for (ii = 0; ii < YPIX; ii++)
	{
	    for (jj = 0; jj < XPIX; jj++)
	    {
		if (ii == YPIX - 1 || ARRAY (ii, jj) != ARRAY (ii + 1, jj))
		{
/* Write this row out, it's not just a repeat of the next one */

/* Write out how many times this line is to be repeated */
		    puth (count, vp_pc._pltout);

/*
 * This entire section tries to efficiently represent ONE RASTER LINE
 */

/*
 * Keep track of "unaccounted for" bytes between
 * bytes containted in a pattern
 */
		    ucount = 0;
/* Loop through a raster line */
		    for (kk = 0; kk < XPIX; kk++)
		    {
/* Try different size patterns */
			for (ll = 1; ll <= MAXREP; ll++)
			{
/* See how far this pattern size works */
			    for (mm = 0; mm <= XPIX - (kk + ll); mm++)
			    {
/* Pattern stopped working */
				if (mm == XPIX - (kk + ll) ||
					ARRAY (ii, kk + mm) != ARRAY (ii, kk + mm + ll))
				{
/* See how many repetitions we got */
				    mm = ll * (1 + (int) (mm / ll));
/* Is it worth it to use this? */
/* (PUTHSIZE is the number of bytes needed for a puth */
				    if (PUTHSIZE * 2 + ll <= 1 + (mm - 1) / bitbyte)
				    {
/* First take care of bytes not in a pattern */
					if (ucount > 0)
					{
					    RASOUT (1, ucount, BIT, &ARRAY (ii, kk - ucount));
					    ucount = 0;
					}
/* Now take care of the bytes in the pattern */
					RASOUT ((int) mm / ll, ll, BIT, &ARRAY (ii, kk));
					kk += mm - 1;
/* Stop looking, we already found what we wanted */
					goto compact_found;
				    }
/* This pattern didn't work. Stop looking at this size and try a longer one */
				    break;
				}
			    }
			}
/* No pattern including this byte, add it to the unaccounted for list */
			ucount++;
		compact_found: 
			continue;
		    }
/* Take care of any bytes left hanging on the end */
		    if (ucount > 0)
		    {
			RASOUT (1, ucount, BIT, &ARRAY (ii, kk - ucount));
		    }
/*
 * END of section that does ONE RASTER LINE
 */


/* Reset counter */
		    count = 1;
/* Exit the loop */
		    break;
		}
	    }
/* If we didn't write it out, it will just be a repeat of the next one */
	    if (jj == XPIX)
		count++;
	}
    }
}
