/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_plot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding (not truncation) before output.
 */

#ifndef FORTRAN
#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

PC              vp_pc =
{
 0.0, 0.0,
 0.0, 0.0,
 1.0, 1.0,
 0.0, 0.0,
 0.0,
 0.0, 0.0, 0.0, 0.0,
 0,
 0,
 stdout,
 TH_NORMAL, TV_NORMAL,
 NO_CHANGE, NO_CHANGE, NO_CHANGE,
};

vp_plot (x, y, down)
    float           x, y;
    int             down;
{
float           dx, dy, dist, dpos, xp, yp, tonext, cosine, sine;
int             i;
double          p_fmod (), sqrt ();

    if (!down || !vp_pc._dashon)	/* if move or no dashes */
    {
	p_pout (x, y, down, vp_pc._pltout);	/* output a move or draw */
	vp_pc._xold = x;
	vp_pc._yold = y;		/* save old x and y */
	vp_pc._dpos = 0.0;		/* reset position in dashes */
	return;
    }
    dx = x - vp_pc._xold;
    dy = y - vp_pc._yold;		/* change in x and y */
    dist = sqrt (dx * dx + dy * dy);	/* distance */
    if (dist <= 0.)
	return;			/* return if no change */
    cosine = dx / dist;
    sine = dy / dist;
    dpos = vp_pc._dpos;		/* current position in dashes */
    vp_pc._dpos = p_fmod (dpos + dist, vp_pc._ddef[3]);	/* next position in
							 * dashes */
    for (i = 0; i < 4 && vp_pc._ddef[i] <= dpos; i++);	/* index to dash def */
    xp = vp_pc._xold;
    yp = vp_pc._yold;		/* initialize xp and yp */
    while (dist > 0.0)
    {
	tonext = vp_pc._ddef[i] - dpos;	/* dist to next gap or dash */
	if (tonext > dist)
	    tonext = dist;
	xp += tonext * cosine;
	yp += tonext * sine;
	p_pout (xp, yp, !(i % 2), vp_pc._pltout);
	dpos = vp_pc._ddef[i];	/* new position */
	i = (i + 1) % 4;	/* i = 0,1,2, or 3 */
	if (i == 0)
	    dpos = 0.0;		/* back to start of dashes */
	dist -= tonext;
    }
    vp_pc._xold = xp;
    vp_pc._yold = yp;
}

p_pout (xp, yp, down, plt)
    float           xp, yp;
    int             down;
    FILE           *plt;
{
int             ix, iy;
    xp = (xp > VP_MAX) ? VP_MAX : xp;
    xp = (xp < -VP_MAX) ? -VP_MAX : xp;
    yp = (yp > VP_MAX) ? VP_MAX : yp;
    yp = (yp < -VP_MAX) ? -VP_MAX : yp;
    ix = ROUND (xp * RPERIN);
    iy = ROUND (yp * RPERIN);
    putc ((down ? VP_DRAW : VP_MOVE), plt);
    puth (ix, plt);
    puth (iy, plt);
}

static double
p_fmod (x, y)
    float           x, y;
{
double          floor ();
    return (x - floor (x / y) * y);
}

#else

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

vpplot_ (x, y, down)
    float          *x, *y;
    int            *down;
{
    vp_plot (*x, *y, *down);
}
#endif
