/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_pline.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Jan 14 1988
 *	Do rounding.
 */

#include <stdio.h>
#include <vplot.h>
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#ifndef UUU
#define PLINE	vppline_
#else UUU
#define UPLINE	vpupline_
#endif UUU
#define LP		*lp
#define XP xp2
#define YP yp2

#else

#ifndef UUU
#define PLINE	vp_pline
#else UUU
#define UPLINE	vp_upline
#endif UUU
#define LP		lp
#define XP xp
#define YP yp

#endif

#ifndef UUU
PLINE (xp, yp, lp)
#else UUU
UPLINE (xp, yp, lp)
#endif UUU
    float          *xp, *yp;
    int             LP;
{
int             i;
int             ix, iy;

#ifdef FORTRAN
register float *xp2, *yp2;
    xp2 = xp;
    yp2 = yp;
#endif FORTRAN

    putc (VP_PLINE, vp_pc._pltout);
    puth (LP, vp_pc._pltout);
    for (i = 0; i < LP; i++)
    {
#ifndef UUU
	ix = ROUND ((*XP) * RPERIN);
	iy = ROUND ((*YP) * RPERIN);
#else UUU
	ix = ROUND ((vp_pc._x0 + ((*XP) - vp_pc._xu0) * vp_pc._xscl) * RPERIN);
	iy = ROUND ((vp_pc._y0 + ((*YP) - vp_pc._yu0) * vp_pc._yscl) * RPERIN);
#endif UUU
	XP++;
	YP++;
	puth (ix, vp_pc._pltout);
	puth (iy, vp_pc._pltout);
    }
}
