/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_gtext.c
 *
 * Joe Dellinger (SEP), Jan 14 1988
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 *
 */

#include <stdio.h>
#include <vplot.h>
#include "params.h"
#include "round.h"
#include "vp_pc.h"

#ifdef FORTRAN

#define TEXT	vpwgtext_
#define X		*x
#define Y		*y
#define XPATH		*xpath
#define YPATH		*ypath
#define XUP		*xup
#define YUP		*yup

#else

#define TEXT	vp_gtext
#define X		x
#define Y		y
#define XPATH		xpath
#define YPATH		ypath
#define XUP		xup
#define YUP		yup

#endif

#ifdef FORTRAN
TEXT (x, y, xpath, ypath, xup, yup, string, nchars)
#else
TEXT (x, y, xpath, ypath, xup, yup, string)
#endif
    float           X, Y;
    float           XPATH, YPATH;
    float           XUP, YUP;
    char           *string;
#ifdef FORTRAN
    int            *nchars;
#endif
{
#ifdef FORTRAN
int             i, length;
#endif

    p_pout (X, Y, 0, vp_pc._pltout);
    putc (VP_GTEXT, vp_pc._pltout);
    puth (ROUND (TEXTVECSCALE * XPATH * RPERIN), vp_pc._pltout);
    puth (ROUND (TEXTVECSCALE * YPATH * RPERIN), vp_pc._pltout);
    puth (ROUND (TEXTVECSCALE * XUP * RPERIN), vp_pc._pltout);
    puth (ROUND (TEXTVECSCALE * YUP * RPERIN), vp_pc._pltout);

#ifdef FORTRAN
/*
 * Try to still work even if they didn't specify nchars.
 */
    length = 80;
    if (nchars != NULL)
    {
	if (*nchars >= 0)
	    length = *nchars;
    }

    for (i = 0; i < length; i++)
    {
	if (*(string + i) == '\0')
	    break;
	putc (*(string + i), vp_pc._pltout);
    }
    putc ('\0', vp_pc._pltout);
#else FORTRAN
    do
    {
	putc (*string, vp_pc._pltout);
    }
    while (*string++);
#endif FORTRAN
}
