/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_dash.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <vplot.h>
#include "vp_pc.h"

#ifdef FORTRAN

#define DASH	vpdash_
#define DASH1	*dash1
#define GAP1	*gap1
#define DASH2	*dash2
#define GAP2	*gap2

#else

#define DASH	vp_dash
#define DASH1	dash1
#define GAP1	gap1
#define DASH2	dash2
#define GAP2	gap2

#endif

DASH (dash1, gap1, dash2, gap2)
    float           DASH1, GAP1, DASH2, GAP2;
{
    if (DASH1 < 0. || GAP1 < 0. || DASH2 < 0. || GAP2 < 0.)
    {
	vp_pc._dashon = 0;
	return;
    }
    vp_pc._ddef[0] = DASH1;
    vp_pc._ddef[1] = vp_pc._ddef[0] + GAP1;
    vp_pc._ddef[2] = vp_pc._ddef[1] + DASH2;
    vp_pc._ddef[3] = vp_pc._ddef[2] + GAP2;
    if (vp_pc._ddef[3] <= 0.)
    {
	vp_pc._dashon = 0;
	return;
    }
    vp_pc._dashon = 1;
    vp_pc._dpos = 0.0;
    return;
}
