/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./lvplot/vp_coltab.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>

#include <vplot.h>
#undef RED
#undef BLUE
#undef GREEN
#include "params.h"
#include "round.h"

#include "vp_pc.h"

#ifdef FORTRAN

#define COLTAB vpcoltab_
#define COLOR *color
#define RED   *red
#define GREEN *green
#define BLUE  *blue

#else

#define COLTAB vp_coltab
#define COLOR color
#define RED   red
#define GREEN green
#define BLUE  blue

#endif

COLTAB (color, red, green, blue)
    int             COLOR;
    float           RED, GREEN, BLUE;
{
int             c, r, g, b;
    c = COLOR;
    r = ROUND (RED * MAX_GUN);
    g = ROUND (GREEN * MAX_GUN);
    b = ROUND (BLUE * MAX_GUN);

    putc (VP_SET_COLOR_TABLE, vp_pc._pltout);
    puth (c, vp_pc._pltout);
    puth (r, vp_pc._pltout);
    puth (g, vp_pc._pltout);
    puth (b, vp_pc._pltout);
}
