/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/utilities/error.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Stewart A. Levin (SEP), June 23 1987
 *	Changed system("stty echo") to ioctl() to restore original tty
 *	settings after we've deliberately forced echo off.
 * Stewart A. Levin (SEP), July 5,1987
 *      Added reset of local mode word corresponding to frontend.c change.
 * Joe Dellinger, Nov 9, 1987
 *	Stew's changes make it necessary to explicitly put "Carriage-Return
 *	Line-Feed" instead of just "\n", since output stream may be
 *	uncooked. "CRLF" is defined in mesgcom.h.
 * Joe Dellinger, Jan 10, 1988
 *	Up to 8 arguments instead of just 3! This routine isn't very kosher.
 * Joe Dellinger, Feb 16, 1988
 *	Use vsprintf on machines that have them.
 */

/*
 * error reporting for VPLOT filters
 * To print text to the outside world, other routines must go through err,
 * which in turn must go through message.
 */

#include <sys/ioctl.h>
#include <sgtty.h>
#include <stdio.h>
#include "../include/err.h"
#include "../include/closestat.h"
#include "../include/mesgcom.h"
#include "../include/extern.h"
extern int      device_open;
extern struct sgttyb tty_clean_state;
extern int      tty_clean_local_mode;

#if defined (SUN) || defined (ULTRIX)

#include <varargs.h>

ERR (va_alist)
va_dcl
{
va_list         apdum;
int             type;
char           *filter, *fmt;

char            string[200];
char            text[150];
extern char    *sprintf (), *strcat ();

    va_start (apdum);
    type = va_arg (apdum, int);
    filter = va_arg (apdum, char *);
    fmt = va_arg (apdum, char *);

    (void) vsprintf (text, fmt, apdum);
    (void) sprintf (string, "%s: ", filter);

    va_end (apdum);

#else

ERR (type, filter, fmt, a1, a2, a3, a4, a5, a6, a7, a8)
    int             type;
    char           *filter, *fmt;
    double          a1, a2, a3, a4, a5, a6, a7, a8;
{
char            string[200];
char            text[150];
extern char    *sprintf (), *strcat ();

    (void) sprintf (text, fmt, a1, a2, a3, a4, a5, a6, a7, a8);
    (void) sprintf (string, "%s: ", filter);

#endif

    message (MESG_READY);

    switch (type)
    {
    case WARN:
	(void) strcat (string, "(warning) ");
	(void) strcat (string, text);
	(void) strcat (string, CRLF);
	message (MESG_TEXT, string);
	message (MESG_DONE);
	break;
    case COMMENT:
	(void) strcat (string, " ");
	(void) strcat (string, text);
	(void) strcat (string, CRLF);
	message (MESG_TEXT, string);
	message (MESG_DONE);
	break;
    case FATAL:
    default:
	(void) strcat (string, "(fatal) ");
	(void) strcat (string, text);
	(void) strcat (string, CRLF);
	message (MESG_TEXT, string);
	message (MESG_DONE);
	if (device_open)
	{
	    dev.close (CLOSE_ERROR);
	    message (MESG_ON);
	    dev.close (CLOSE_DONE);
	    fflush (pltout);
	}
	if (!allowecho)		/* restore terminal to original tty state */
	{
	    (void) ioctl ((int) (fileno (pltout)), TIOCLSET,
			  (char *) (&tty_clean_local_mode));
	    (void) ioctl ((int) (fileno (pltout)), TIOCSETN,
			  (char *) (&tty_clean_state));
	}
	exit (-1);
    }
}
