/*
 *
 *  source file:   ./filters/loclib/err.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Feb 16 1988
 *	Use VARARGS and vsprintf if they are available.
 */

/*
 *	error abortion subroutine
 *
 *	a is a printf format string, while b-h are optional arguments
 *	When the subroutine is called, the program will stop after
 *	printing its message.
 *	Example:	err("Cannot divide %f by %f\n", x, y);
 *
 *      perror() is wiped out by including a dummy version of it here.
 *	this is because perror has the audacity to print directly to
 *	stderr, which we can't allow. this special version of err replaces
 *	the normal seplib version and forces seplib to go through ERR,
 *	the vplot filter subroutine for error messages that takes special
 *	care not to try to print messages in the middle of plotting.
 */
#include <stdio.h>
#include "../include/err.h"
#include "../include/extern.h"

#if defined (SUN) || defined (ultrix)
#include <varargs.h>
/*VARARGS1*/
err (va_alist)
va_dcl
{
va_list         apdum;
extern char   **xargv;
char           *format;
char            string[120];

    va_start (apdum);
    format = va_arg (apdum, char *);
    vsprintf (string, format, apdum);
    va_end (apdum);

    ERR (FATAL, name, "sep: %s", string);
/*
 * Force the linker to link in my version of perror
 */
    perror ();
}
#else
/*VARARGS1*/
err (a, b, c, d, e, f, g, h)
    char           *a, *b, *c, *d, *e, *f, *g, *h;
{
extern char   **xargv;
char            string[120];

    sprintf (string, a, b, c, d, e, f, g, h);
    ERR (FATAL, name, "sep: %s", string);
/*
 * Force the linker to link in my version of perror
 */
    perror ();
}
#endif

perror ()
{
}
