/*
 *
 *  source file:   ./filters/loclib/bufpar.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */


/* bufpar.c: get and store getpar-style parameters from a text
 *		buffer.
 *	bufpar_scan:	parse the buffer, and make a hashed list
 *	bufpar_:			return a value from the list
 *	bufpar_string_store:	add a {tag,value} pair to the list
 *	bufpar_free:	erase the list
 *								-- c. r. karish  18 dec 1986
 */

#include "fastpar.h"
#define NULL 0
#define BUF_QUEUE_SIZE 127
#define POINTER unsigned long
char           *alloc ();
static hash_item *buf_queue[BUF_QUEUE_SIZE];
static int      buf_queue_size = BUF_QUEUE_SIZE;

int
bufpar_scan (strbuf, buflen, reset)
    register char  *strbuf;
    int             buflen, reset;
{
char           *buffer;
register char  *bptr;
register int    ii;

    /* make sure the 'queue' is clean */
    if (reset)
	bzero ((char *) buf_queue, BUF_QUEUE_SIZE * sizeof (POINTER));

    /* set up the input */
    buffer = alloc (buflen + 3);
    bptr = buffer;
    *bptr++ = '\n';
    for (ii = 0; ii < buflen; ii++)
	*bptr++ = *strbuf++;
    *bptr++ = '\n';
    *bptr = '\0';
    getpar_push_input (buffer, 1);

    /* scan input, and put results on 'queue' */
    getpar_scan (buf_queue, buf_queue_size);
}

int
bufpar (tag, type, val)
    char           *tag, *type;
    MIXED           val;
{
    return (getpar_decode (buf_queue, buf_queue_size, tag, type, val));
}

bufpar_add_string (string)
    char           *string;
{
    getpar_string_store (buf_queue, buf_queue_size, string);
}

/* aliases: for calling from fortran */

bpscan_ (buffer)
    char           *buffer;
{
    bufpar_scan (buffer);
}

bufpar_ (tag, type, val)
    char           *tag, *type;
    MIXED           val;
{
    bufpar (tag, type, val);
}

bpadds_ (string)
    char           *string;
{
    bufpar_add_string (string);
}
