/*
 * commands to the device's "attributes" routine
 */

#define	SET_COLOR		1
#define SET_COLOR_TABLE 	2
#define SET_WINDOW		3
#define NEW_DASH		4
#define NEW_PAT			5
#define NEW_FONT		6
#define NEW_OVERLAY		7
#define NEW_ALIGN		8
#define NEW_FAT			9
#define BEGIN_GROUP		10
#define END_GROUP		11

#define DOVPLOT_CONT		0	/* MUST be zero */
#define DOVPLOT_EXIT		1

/*
 * Uses:
 * Dummy arguments are not used, but should be listed to make some finicky
 * compilers happy, even if you don't use any of the commands that require
 * all 4 arguments. By the same token, you should explicitly declare a
 * return value of 0 even for those calls that don't use the return value.
 *
 * dev.attributes(SET_COLOR, col, dummy1, dummy2, dummy3)
 *
 * Set the current drawing color to col. The device is assumed to
 * start out with the current drawing color 7 = WHITE.
 *
 * dev.attributes(SET_COLOR_TABLE, col, red, green, blue)
 * 
 * Set color number col to have the color (red,green,blue).
 * Red, green, and blue are in the range from 0 to MAX_GUN (255),
 * with 0 being off and MAX_GUN being fully on.
 * Thus, (0,0,0) is black, (128,128,128) is grey, (255,255,255) is white,
 * (255,0,0) is red, (255,255,0) is yellow, etc... The device is assumed
 * to start out with colors 0 through 7 set as in the vplot standard.
 *
 * dev.attributes(SET_WINDOW, xmin, ymin, xmax, ymax)
 *
 * Set current clipping window. (xmin,ymin) is the lower-leftmost
 * displayable point. (xmax,ymax) is the upper-rightmost displayable point.
 * Only necessary to support this if smart_clip=YES, smart_raster=YES, or
 * you don't use a generic routine (genarea) to clip polygons for you.
 * After dev.reset has been called, dovplot assumes that the clipping
 * window is set by the device to the edge of the device's screen.
 * Dev.attributes(SET_WINDOW, ...) will thereafter be called whenever
 * the clipping window is changed from its previous setting. (Thus,
 * if no clipping window is ever set at all, dev.attributes(SET_WINDOW, ...)
 * will never be called.) It is possible for xmin > xmax or ymin > ymax.
 * If this happens everything should be clipped away.
 *
 * dev.attributes(NEW_DASH, dashon, dummy1, dummy2, dummy3)
 *
 * Warn the device that the current dashed line pattern has just
 * been changed. "dashon" is the new value of the external variable
 * dashon. (See the dev.vector documentation.)
 *
 * dev.attributes(NEW_PAT, ipat, dummy1, dummy2, dummy3)
 *
 * Warn the device that raster pattern "ipat" has been defined
 * or redefined. The device does not have to allow re-definition
 * of defined patterns. (See the dev.area documentation for a
 * description of how patterns are stored.)
 *
 * dev.attributes(NEW_FONT, txfont, txprec, txovly, dummy1)
 *
 * Warn the device that the text font, precision, or overlay may have
 * been changed. A value of "-1" means no change from the previous value,
 * which may be a device-dependent default. This form of dev.attributes
 * will be called whenever the user uses the "set text font and precision"
 * vplot command (and only then), so you probably should check to see if
 * anything really changed before bothering the device. Even better,
 * only check these variables at the time that you output hardware text,
 * and don't bother with this option in dev.attributes at all.
 *
 * dev.attributes(NEW_OVERLAY, overlay, dummy1, dummy2, dummy3)
 *
 * Warn the device that the overlay mode may have been changed. Again,
 * most devices will ignore this dev.attributes call, and check the
 * external variable overlay only when they actually need to know what
 * it is.
 *
 * dev.attributes(NEW_ALIGN, txalign.hor, txalign.ver, dummy1, dummy2)
 *
 * Warn the device that the text alignment mode has been changed. Again,
 * most devices will ignore this call and just check the alignment
 * when hardware text is drawn.
 *
 * dev.attributes(NEW_FAT, fat, dummy1, dummy2, dummy3)
 *
 * Warn the device that the fatness has been changed. Again, most devices
 * should ignore this call and just check the fatness before processing
 * any of the 3 things in which it is used: vectors, text, markers.
 * Check the dev.vector documentation for caveats similar to those for
 * the NEW_PAT case.
 *
 * dev.attributes(BEGIN_GROUP, group_number, pos, dummy1, dummy2)
 * dev.attributes(END_GROUP, group_number, dummy1, dummy2, dummy3)
 *
 * extern char group_name[MAXFLEN+1];
 *
 * return iflag
 *
 * Everything between these calls is grouped as one "object".
 * Objects may be nested. Objects may not extend across erases,
 * breaks, or files. The name of the most recently begun object is
 * stored in the external variable group_name. Group_name is defined
 * in extern.h. "group_number" gives the heirarchical order of the
 * object. Each plot frame is itself an object of group number 0.
 * "pos" gives the offset from the start of the file of the start of
 * this object. If "pos" is negative, then the input file is one
 * for which seeks don't work. Dev.attributes(END_GROUP,...) returns
 * "iflag" to tell dovplot what it should do next.
 * If "iflag" is DOVPLOT_CONT (=0), then dovplot should continue exactly
 * as normal. If "iflag" is DOVPLOT_EXIT, then dovplot will exit upon the
 * return of this call. Note that K+R says that failing to declare
 * a return value returns garbage, so you MUST declare a return value
 * for dev.attributes(END_GROUP,...). To help make sure you do this,
 * dovplot will issue a warning message if an unknown return value is
 * given.
 *
 */
