/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/genlib/genvector.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Generic vector routine for devices that don't support fatness.
 * This version tries to be smart and minimize the "motion of the pen",
 * and tries to prolong strings of "draws" where possible.
 */
#include <stdio.h>
#include "../include/extern.h"
#define MOVE 0
#define DRAW 1

extern int      smart_clip;
extern int      lost;
extern int      fatvec ();

genvector (x1, y1, x2, y2, nfat, dashon)
    int             x1, y1, x2, y2;
    int             nfat, dashon;
{
static int      xlst, ylst;
int             d1, d2;

    if (nfat < 0)
	return;

    if (dashon)
    {
	dashvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    if (nfat)			/* Recursively calls itself to make fat lines */
    {
	fatvec (x1, y1, x2, y2, nfat, dashon);
	return;
    }

    /*
     * Do clipping 
     */
    if (!smart_clip)
	if (clip (&x1, &y1, &x2, &y2))
	    return;
    /*
     * Important special case: Zero-length vector at the end of what you've
     * already plotted. Don't need to do anything. 
     */
    if (x1 == x2 && y1 == y2 && !lost && x1 == xlst && y1 == ylst)
    {
	return;
    }

    /*
     * Minimize movement of "pen" 
     */
    if (!lost)
    {
	d1 = abs (x1 - xlst) + abs (y1 - ylst);
	d2 = abs (x2 - xlst) + abs (y2 - ylst);
	if (d2 < d1)
	{
	    d1 = x1;
	    d2 = y1;
	    x1 = x2;
	    y1 = y2;
	    x2 = d1;
	    y2 = d2;
	}
    }

    if ((x1 != xlst) || (y1 != ylst) || lost)
    {
	/* Make sure it is a move, not a draw */
	if (!lost && abs (x1 - xlst) <= 1 && abs (y1 - ylst) <= 1)
	{
	    /*
	     * We're within one pixel, so go ahead and draw a vector to the
	     * new point. This avoids having to leave and re-enter vector
	     * mode. 
	     */
	    dev.plot (x1, y1, DRAW);
	}
	else
	{
	    dev.plot (x1, y1, MOVE);
	}
    }
    dev.plot (x2, y2, DRAW);
    xlst = x2;
    ylst = y2;
}
