/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/Tests/libvplot_example.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include    <math.h>
#include    <vplot.h>
#include    <stdio.h>

/*
 * Sample program to demonstrate simple libvplot usage.
 *      Excerpted from 'legend.c', by C. R. Karish:
 *      format entries for a legend for a geologic map.
 *  To compile:
 *      cc -o example vplot_example.c -lvplot -lm
 *  To run:
 *      example < infile > outfile
 *      tube outfile
 *  Sample input:       (remove asterisks)
 *      unit "Qa"  "Quaternary alluvium"
 *      unit "Tb"  "Tertiary basalt"
 *      unit "Kg"  "biotite monzogranite"
 *      unit "Krp"  "rhyolite porphyry"
 *      unit "Krd"  "biotite rhyodacite"
 */

/*
 * external parameters, used by many subroutines
 */
float           boxsz[2];	/* size of the symbol box, in inches */
float           tab[2];	/* locations of tab stops, in inches */
int             charsz;	/* text size used for explanations (in vplot size
			 * units) */
float           vspace;	/* vertical spacing for rock unit entries */
float           vpos;	/* present location on the page (inches) */

main ()
{
char            command[30], line[125], symbol[30], text[90];
int             count;

    /*
     * set global geometric parameters 
     */

    vpos = 10.3;		/* start at 10.3 inches from bottom of page */
    vspace = 0.90;		/* base line spacing = 0.90 inches */
    charsz = 10;		/* default text size = .30 inches */
    boxsz[0] = 1.0;		/* default box: 1.0 x 0.70 inches */
    boxsz[1] = 0.70;
    tab[0] = 1.0;		/* default tabs: 1.0 and 3.5 inches */
    tab[1] = 3.5;

    /*
     * set up a vplot output stream and coordinate system 
     */
    vp_filep (stdout);		/* initialize pc structure and open stream */
    vp_style (STANDARD);	/* origin at lower left; y axis vertical */
    vp_clip (0., 0., 8.5, 11.0);/* set clipping window */
    /* (wider than screen!) */
    vp_tfont (1, STROKE, 0);	/* use Roman simplex, full precision, */
    /* no special overlay processing */
    vp_fat ((int) (charsz / 2));/* set line width, scaled to text size */
    vp_orig (0., 0.);		/* set the user origin to coincide with */
    /* the device origin (same as default) */

    /*
     * main loop: read and interpret input file 
     */
    while (gets (line) != NULL)
    {
	if (sscanf (line, "%s", command) == 0)	/* skip blank lines */
	    continue;
	if (command[0] == '#')	/* ... and comments */
	    continue;
	if ((count = sscanf (line,	/* parse strings from input */
			   "%*s \"%[^\"]\" \"%[^\"]\"", symbol, text)) != 2)
	{
	    fprintf (stderr, "unit count = %d\n", count);
	    fprintf (stderr, "%s\n", line);	/* complain if argument */
	    continue;		/* count is wrong */
	}
	mapunit (symbol, text);	/* produce some output */
    }				/* end of main loop */
    vp_endplot ();		/* close output stream */
}

mapunit (symbol, text)	/* produce an entry for a map legend */
    char           *symbol, *text;
{
    if (vpos < 1.0)		/* leave 1" bottom margin */
	feedpage ();
    vpos -= vspace / 2;		/* space down a half line */
    if (strcmp (symbol, "nobox"))	/* strcmp==TRUE means `no match' */
    {
	drawbox (tab[0], vpos);	/* draw the box */
	vp_tjust (TH_CENTER, TV_HALF);	/* center the symbol in the box */
	vp_fat ((int) ((charsz - 1) / 2));	/* pick a good text fatness */
	vp_text (tab[0] + (boxsz[0] / 2),
		 vpos, charsz - 1, 0, symbol);	/* write the map symbol */
    }
    vp_fat ((int) (charsz / 2));
    vp_tjust (TH_LEFT, TV_HALF);/* reset left justification */
    vp_text (tab[1], vpos, charsz, 0, text);	/* write the explanation */
    vpos -= vspace / 2;		/* space down a half line */
}


/*
 * draw a box, boxsz[0] by boxsz[1] inches, left edge at xpos,
 *      centered vertically at ypos:
 */

drawbox (xpos, ypos)
    float           xpos, ypos;
{
    vp_fat ((int) (charsz / 2));/* set linewidth, same as for text */
    vp_move (xpos, ypos - (boxsz[1] / 2));	/* move to the upper left
						 * corner */
    vp_draw (xpos + boxsz[0], ypos - (boxsz[1] / 2));	/* draw it. */
    vp_draw (xpos + boxsz[0], ypos + (boxsz[1] / 2));
    vp_draw (xpos, ypos + (boxsz[1] / 2));
    vp_draw (xpos, ypos - (boxsz[1] / 2));
}

feedpage ()
{
    vp_erase ();		/* feed a page, and reset defaults */
    vp_clip (0., 0., 8.0, 11.0);/* reset our clipping window */
    vp_tfont (1, STROKE, 0);	/* reset our font */
    vp_fat ((int) (charsz / 2));/* reset our fatness */
    vp_orig (0., 0.);		/* reset our origin */
    vpos = 10.3;		/* start at the top of the page */
}
