/*
 *
 *  source file:   ./Hershey/hertovplot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * This program converts the Hershey fonts in the form distributed with
 * mod.sources into "Vplot fonts", given a ".hmp" file as the first argument.
 * Here is a sample .hmp file, that for the font "romanc":
 *
2199    2214    2217    2275    2274    2271    2272    2251
2221    2222    2219    2232    2211    2231    2210    2220
2200-2209
2212    2213    2241    2238    2242    2215    2273
2001-2026
2223    804     2224    2262    999     2252
2101-2126
2225    2229    2226    2246    2218
2177-2182
 *
 * It is simply a list of the Hershey glyphs to use in that font.
 * For example, the first glyph would be number 2199, the second number 2214,
 * etc, etc. As a shorthand convenience, the notation X-Y will give the
 * inclusive range from number X to number Y. (2200-2209 are the glyphs for
 * the digits, as you might expect.)
 *
 * The optional second argument (default 32) is an integer giving the
 * ASCII value of the first character in the font. (Note that there CAN
 * be more than 256 characters in a font!)
 *
 * For example,
 * cat hersh.oc* | hershtovplot romanc.hmp 32 > romanc_font
 *
 * You have to go in yourself and add such information as the letter spacing,
 * top height, bottom, etc, etc. The hershey fonts provide the left and right
 * width data, which is used, but do not provide data about where to center
 * the symbol vertically if it is used as a marker. This must be edited in
 * by hand if the default calculated by "makefont" is unacceptable.
 *
 * SEE ALSO: makefont.c, a program which "packs" Vplot font files into
 * ".include" fonts so that they can be included into font_definitions.h
 *  and thus be used with "gentext.c". It also makes runtime-loadable
 *  ".bin" fonts. It also gives the format of a vplot font in the comments
 *  at the start of the source!
 *
 * - Joe Dellinger, Stanford University Dept of Geophysics
 *
 * Bits of this code are stolen from "hershey.c" by James Hurt.
 *
 */

#include <stdio.h>
#include <strings.h>

/*
 * scanint: a function to scan an integer, using n characters of
 *          the input file, ignoring newlines. (scanf won't work
 *          because it also ignores blanks)
 */
int
scanint (n)
    int             n;
{
char            buf[20];
int             i, c;

    for (i = 0; i < n; i++)
    {
	while ((c = getchar ()) == '\n');	/* discard spare newlines */
	if (c == EOF)
	    return (-1);
	buf[i] = c;
    }

    buf[i] = 0;
    return (atoi (buf));
}

main (argc, argv)
    int             argc;
    char          **argv;
{
int             ich, nch, i, j, x, y;
int             font[32000];
int             line[2][1000];
int             move, ipnt;
FILE           *fp;
char            string[100];
int             nc, start;

    if (argc == 1)
    {
	fprintf (stderr, "Sorry, but you must specify a .hmp file for me to use\n");
	exit (1);
    }
    fp = fopen (argv[1], "r");
    if (fp == NULL)
    {
	fprintf (stderr, "Can't open the file %s.\n", argv[1]);
	exit (0);
    }

    if (argc == 3)
    {
	start = atoi (argv[2]);
    }
    else
	start = 32;

    nc = 0;
    i = 0;
    while (fscanf (fp, "%s", string) != EOF)
    {
	if (index (string, '-'))
	{
	    for (j = atoi (string); j <= atoi (index (string, '-') + 1); j++)
	    {
		font[i] = j;
		i++;
		nc++;
	    }
	}
	else
	{
	    font[i] = atoi (string);
	    i++;
	    nc++;
	}
    }

    fprintf (stderr, "%d glyphs in this font.\n", nc);

    while (1)
    {
	if ((ich = scanint (5)) < 1)
	{
	    exit (0);
	}
	nch = scanint (3);

	for (i = 0; i < nch; i++)
	{
	    if ((i == 32) || (i == 68) || (i == 104) || (i == 140))
		getchar ();	/* skip newlines */
	    line[0][i] = getchar ();
	    line[1][i] = getchar ();
	}
	getchar ();

	for (i = 0; i < nc; i++)
	{
	    if (font[i] == ich)
		break;
	}

	if (i < nc)
	{
	    fprintf (stderr, "hershey=%d, place=%d\n", ich, i);
/*		     .. left and right widths */

	    x = -((int) line[0][0] - (int) 'R');
	    y = (int) line[1][0] - (int) 'R';

	    move = i + start;
	    if (move >= '!' && move <= '~')
		printf ("e %d %d %c\n", x, y, move);
	    else
		printf ("e %d %d \\%d\n", x, y, move);

	    move = 1;
	    for (ipnt = 1; ipnt < nch; ipnt++)
	    {
		if (line[0][ipnt] == ' ')
		{
		    move = 1;
		}
		else
		{
		    x = (int) line[0][ipnt] - (int) 'R';
		    y = (int) line[1][ipnt] - (int) 'R';
		    if (move)
			printf ("m ");
		    else
			printf ("d ");
		    move = 0;
		    printf ("%d %d\n", x, -y);
		}
	    }
	}
    }
}
