/*
 *
 *  source file:   ./Hershey/hertogrid.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * This program allows you to scan the glyphs in the Hershey character sets,
 * and tells you the Hershey glyph number of each.
 * This allows you to construct appropriate .hmp files for a new font you are
 * putting together.
 * .hmp files have already been created for all the occidental files, but nothing
 * has been done with the oriental ones. Anyone out there in Japan want to do this?
 *
 * This program is used by:
 * cat hershey.oc? | hertogrid | plas | pen_filter
 *
 * As a start to anyone out there that wants to do Japanese,
 * Hirigana runs from 6000 to 6079, and
 * Katakana runs from 6100 to 6179.
 *
 * (What do you get with glyphs 1056 and then 5055?)
 *
 * Joe Dellinger,
 * Stanford University Dept of Geophysics
 */
#include <stdio.h>
/*
 * scanint: a function to scan an integer, using n characters of
 *          the input file, ignoring newlines. (scanf won't work
 *          because it also ignores blanks)
 */
int
scanint (n)
    int             n;
{
char            buf[20];
int             i, c;

    for (i = 0; i < n; i++)
    {
	while ((c = getchar ()) == '\n');	/* discard spare newlines */
	if (c == EOF)
	    return (-1);
	buf[i] = c;
    }

    buf[i] = 0;
    return (atoi (buf));
}

int             rows = 10, cols = 10, scale = 11, maxpage = 10;
main ()
{
int             ich, nch, i, x, y, k, kn, xx, yy;
int             line[2][1000];
int             move, ipnt;

    printf ("S r\nJ 2 5\n");
    for (k = 0, kn = rows * cols * maxpage; k < kn; k++)
    {
	if ((ich = scanint (5)) < 1)
	{
	    exit (0);
	}
	nch = scanint (3);

	for (i = 0; i < nch; i++)
	{
	    if ((i == 32) || (i == 68) || (i == 104) || (i == 140))
		getchar ();	/* skip newlines */
	    line[0][i] = getchar ();
	    line[1][i] = getchar ();
	}
	getchar ();

/*		     .. left and right widths */

	if (k % (rows * cols) == 0 && k > 0)
	    printf ("e\n");
	xx = (k % rows) * 40 + 20;
	yy = (k % (rows * cols)) / rows * 47 + 25;

	printf ("m %d %d\n", scale * xx, scale * (yy - 15));
	printf ("T 2 0\n");
	printf ("%d\n", ich);

	move = 1;
	for (ipnt = 1; ipnt < nch; ipnt++)
	{
	    if (line[0][ipnt] == ' ')
	    {
		move = 1;
	    }
	    else
	    {
		x = (int) line[0][ipnt] - (int) 'R' + xx;
		y = yy - (int) line[1][ipnt] + (int) 'R';
		if (move)
		    printf ("m ");
		else
		    printf ("d ");
		move = 0;
		printf ("%d %d\n", scale * x, scale * y);
	    }
	}
    }
}
