/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/vplib/vptextT.c
 *
 * Joe Dellinger (SEP), Dec 19 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * THIS FILE SHOWS HOW TO DO TEXT USING THE VP_TEXT COMMAND.
 * I INCLUDE THIS AS AN EXAMPLE OF HOW TO SUPPORT HARDWARE
 * TEXT WELL ON DEVICES THAT CAN'T DO ARBITRARY TRANSFORMATIONS.
 */

#include	<stdio.h>
#include	<math.h>
#include	"../include/vplot.h"
#include	"../include/extern.h"
#include	"../include/enum.h"
#include	"../include/params.h"
#include	"../include/round.h"
#include	"./vp.h"

static double   path_orient_dx, path_orient_dy;
static double   up_orient_dx, up_orient_dy;

extern int
gentext (), nulldev ();

vptext (string, pathx, pathy, upx, upy)
    char           *string;
    float           pathx, pathy, upx, upy;
{
double          fpathx, fpathy, fupx, fupy;
double          up, path;
int             vpsize, vporient;
float           dot, cross, aspect;
int             (*savevector) ();
int             (*saveattributes) ();
int             (*savearea) ();

    vpsetflag = NO;
    lost = YES;

    if (*string == '\0')
	return;

/*
 * Set the inital parameters
 */
    fpathx = (double) pathx;
    fpathy = (double) pathy;
    fupx = (double) upx;
    fupy = (double) upy;

    path = sqrt ((double) (fpathx * fpathx + fpathy * fpathy));
    up = sqrt ((double) (fupx * fupx + fupy * fupy));

    path_orient_dx = fpathx / path;
    path_orient_dy = fpathy / path;
    up_orient_dx = fupx / up;
    up_orient_dy = fupy / up;

/*
 * Check for skewed coordinates
 *
 * If the path and orient vectors are scewed by more than 2
 * degrees, or if the height/width ratio is more than 1 percent
 * off, or if the letters are mirrored, then use vector text.
 */

    dot = path_orient_dx * up_orient_dx +
     path_orient_dy * up_orient_dy;

    cross = path_orient_dx * up_orient_dy -
     path_orient_dy * up_orient_dx;

    if (path != 0.)
    {
	aspect = up / path;
    }
    else
    {
	if (up == 0.)
	    aspect = 1.;
	else
	    aspect = 0.;
    }

    if (fabs (dot) > .01 || cross < 0. || fabs (aspect - 1.) > .01)
    {
	gentext (string, pathx, pathy, upx, upy);
	return;
    }

/*
 *   Set the font and size
 */
    vpsize = ROUND (TXPERIN * path / RPERIN);
    vporient = ROUND (acos (path_orient_dx) * 180 / 3.141592654);
    if (pathy < 0)
	vporient *= -1;

    vp_text ((float) xold / RPERIN, (float) yold / RPERIN,
	     vpsize, vporient, string);

/*
 *   Now reset the pen position.
 *   Do a dummy run through (if this indeed a gentext font)
 */
    if (txfont < NUMGENFONT)
    {
	savevector = dev.vector;
	saveattributes = dev.attributes;
	savearea = dev.area;

/*
 *   Disconnect everything except error messages
 */
	dev.vector = nulldev;
	dev.attributes = nulldev;
	dev.area = nulldev;

	gentext (string, pathx, pathy, upx, upy);

	dev.vector = savevector;
	dev.attributes = saveattributes;
	dev.area = savearea;

	vp_move ((float) xold / RPERIN, (float) yold / RPERIN);
    }
}
