/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/teklib/tekopen.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Device open routine for tek4010 emulators (no-op for a real tek401x)
 *	Devices supported:
 *		graphon 140, 230, 235, 240
 *		selanar hi-rez 100
 *		digital engineering retrographics boards in dec vt102 and vt131
 *			and televideo 950 terminals
 * 		seiko d-scan (gr-1104), in monochrome
 *
 *							chuck karish  25 november 1986
 */

#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"
#include "../teklib/tek.h"
extern FILE    *pltout;
extern char     wstype[];
extern char     callname[];

tekopen ()
{
/*
 * physical device parameters
 */
    dev_xmax = 1000;
    dev_ymax = 750;
    dev_xmin = 0;
    dev_ymin = 0;
    pixels_per_inch = 78.;
    aspect_ratio = 1.;

/*
 * device capabilities
 */
    need_end_erase = NO;
    buffer_output = YES;
    smart_clip = NO;
    num_col = 0;

    if (!strcmp (wstype, "default"))
    {
	strcpy (wstype, "tek401X");
    }
    if ((!strcmp (wstype, "graphon")) ||
	(!strcmp (callname, "gopen")))
    {
	strcpy (wstype, "graphon");
	dev_xmax = 1023;
	dev_ymax = 780;
	pixels_per_inch = 128;
	need_end_erase = NO;

	fprintf (pltout, "\0331");	/* go into 4014 mode and stay there */
	fflush (stdout);
	endpause = YES;
    }

    else
	if ((!strcmp (wstype, "retrographics")) ||
	    (!strcmp (callname, "retpen")) ||
	    (!strcmp (callname, "ret")))
    {
	strcpy (wstype, "retrographics");
	dev_xmax = 1023;
	dev_ymax = 780;
	pixels_per_inch = 128;

	fprintf (pltout, "\035");	/*go into 4010 mode and stay there */
	fflush (stdout);
    }

    else
	if ((!strcmp (wstype, "selanar")) ||
	    (!strcmp (callname, "selpen")))
    {
	strcpy (wstype, "selanar");
	dev_xmax = 1023;
	dev_ymax = 780;
	pixels_per_inch = 128;
	need_end_erase = YES;
	endpause = YES;
/*
 * The text screen must be erased to keep fragments of the text
 * plane from flashing by while drawing is taking place.
 */
	fprintf (pltout, "\033[0;0H");	/* return cursor to home position */
	fprintf (pltout, "\033[2J");	/* erase text screen */
	fprintf (pltout, "\033[>0t");	/* turn off text video */
	fprintf (pltout, "\0331");	/* go to 4014 mode and stay there */
	fflush (stdout);
    }
    else
	if ((!strcmp (wstype, "dscan")) ||
	    (!strcmp (callname, "dscanpen")))
    {
	strcpy (wstype, "dscan");
	dev_xmax = 1023;
	dev_ymax = 779;
	pixels_per_inch = 128;
	need_end_erase = NO;
	buffer_output = YES;
	smart_clip = NO;
	num_col = 0;

	fprintf (pltout, "\033*");	/* go into 4014 mode and stay there */
	fflush (stdout);
	endpause = YES;
    }
}
