/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/teklib/tekconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * tektronix 4010-4014 configuration
 * distinctive attributes of emulators are dealt with in tekopen.c
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"

/*
 * mandatory declarations and initializations
 */
#ifdef SEP
char            name[] = "Tekpen";
#else
char            name[] = "tekpen";
#endif
#include "tekdoc.h"

/*
 * device routine table
 */
extern int
tekopen (), tekmessage (), tekerase (), tekclose ();
extern int
genvector (), gentext (), genraster (), genmarker ();
extern int
tekplot (), tekpoint ();
extern int
vecarea (), geninteract ();
extern int      nulldev ();

struct device   dev = {

 /* control routines */
		       tekopen,	/* open */
		       nulldev,	/* reset */
		       tekmessage,	/* message */
		       tekerase,	/* erase */
		       tekclose,	/* close */

 /* high level output */
		       genvector,	/* vector */
		       genmarker,	/* marker */
		       gentext,	/* text */
		       nulldev /*vecarea*/ ,	/* area */
		       genraster,	/* raster */
		       tekpoint,	/* point */
		       nulldev,	/* attributes */

 /* input */
		       nulldev,	/* getpoint */
		       geninteract,	/* interact */

 /* low level output */
		       tekplot,	/* plot */
		       nulldev,	/* startpoly */
		       nulldev,	/* midpoly */
		       nulldev	/* endpoly */
};
