/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekreset.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/* 
 * Put the terminal into standard configuration.
 */
#include <stdio.h>
#include "../include/attrcom.h"
#include "../include/params.h"
#include "ctek.h"

extern FILE    *pltout;
extern int      dev_xmax, dev_ymax, dev_xmin, dev_ymin;

ctekreset ()
{
    /*
     * Set the graphics window. 
     */
    cteksetmode (TEK);
    fprintf (pltout, "%cRW", ESC);
    ctekxypack (dev_xmin, dev_ymin);
    ctekxypack (dev_xmax, dev_ymax);

    /*
     * Turn off dashed lines. Set color to default color (usually white, but
     * controlled by color table). 
     */
    cteklinestyle (0);
    ctekattributes (SET_COLOR, DEFAULT_COLOR, 0, 0, 0);
}
