/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekraster.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Feb 16 1988
 *	Updated raster call.
 */

#include	<stdio.h>
#include	"ctek.h"
#include "../include/enum.h"
#include "../include/extern.h"
extern FILE    *pltout;
extern int      need_devcolor, overlay;
extern int      genraster1 ();
extern int      lost;

/*
 * IMPORTANT NOTE
 * We couldn't just change the raster line which is handed to us to
 * do the color mapping, because the same line MAY get handed to us
 * again, which creates havoc when it gets mapped TWICE.
 */

ctekraster (count, out_of, xpos, ypos, length, orient, raster, dummy1, dummy2)
    int             count, out_of, xpos, ypos, length, orient, dummy1, dummy2;
    char           *raster;
{
register int    ii, jj, kk;
int             length2;
int             pixel[6];	/* Most number pixels per one character */
static int      pix_pak = 0;
int             xbreak;
int             failure_count;

/* Why were we even called? */
    if (length == 0)
	return;

/*
 * pixel stuff has to overwrite
 */
    overlay = NO;

    if (orient != 0)
    {
	genraster1 (count, out_of, xpos, ypos, length, raster, orient);
	return;
    }

/*
 * If it is just a solid line (or nearly solid) of a few colors, better to use
 * genraster1.
 */
    xbreak = 0;
    failure_count = 0;
    for (jj = 1; jj < length; jj++)
    {
	if (raster[jj] != raster[jj - 1])
	{
	    if (jj - xbreak < 10)
	    {
		failure_count++;
		if (failure_count > 2)
		    break;
	    }
	    xbreak = jj;
	}
    }
    if (jj == length)
    {
	genraster1 (0, 1, xpos, ypos, length, raster, orient);
	return;
    }


/*
 * Probably "runlength write" would be more efficient here in many
 * circumstances. Anyone want to make this use that when it is faster?
 * -JAD
 */

/* Do tek4105 Raster write */

    cteksetmode (TEK);

/* See how many bits we need to use */
    jj = 0;
    for (ii = 0; ii < length; ii++)
    {
	kk = ctekcolmap ((int) raster[ii]);
	if (jj < kk)
	    jj = kk;
	if (jj > 3)
	    break;
    }
    switch (jj)
    {
    case 0:
    case 1:
	jj = 6;
	break;
    case 2:
    case 3:
	jj = 3;
	break;
    default:
	jj = 2;
	break;
    }

    if (pix_pak != jj)
    {
	pix_pak = jj;		/* pix_pak is number of pixels per char */
	fprintf (pltout, "%cRU1", ESC);	/* Begin Pixel Operations */
	tekipack (11);		/* Replace whatever was there before */
	tekipack (6 / pix_pak);	/* 6/pix_pak bits per pixel */
    }


    fprintf (pltout, "%cRH", ESC);	/* position pixel beam */
    ctekxypack (xpos, ypos);

/* length2 is number of characters needed to hold length pixels */
    length2 = length / pix_pak;
    if (length % pix_pak != 0)
	length2++;

    fprintf (pltout, "%cRP", ESC);	/* raster write (one line) */
    tekipack (length);		/* Number of pixels to set, */
    tekipack (length2);		/* encoded into this many characters */

    for (jj = 0; jj < length; jj += pix_pak)
    {
	for (kk = 0; kk < pix_pak; kk++)
	{
	    if (jj + kk >= length)
	    {
		pixel[kk] = 0;
		break;
	    }
	    pixel[kk] = ctekcolmap ((int) raster[jj + kk]);
	}

	pixpack (pixel, pix_pak);
    }
    lost = 1;
    need_devcolor = YES;
    return;
}
