/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekpoly.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Polygon routines.
 * Shading option is handled at higher level, since these routines produce
 * filled polygons.
 * Uses draw_border set by termcolor().
 */
/*
 * JAD ----
 * Since VPLOT will always draw the border, always have it set to NO!
 */
#include	<stdio.h>
#include	"ctek.h"
#include	"../include/enum.h"
extern FILE    *pltout;

extern int      draw_border;
int             poly_started;

ctekstartpoly (npts)
    int             npts;
{
    poly_started = NO;
}

ctekmidpoly (x, y)
    int             x, y;
{

    if (!poly_started)
    {
	cteksetmode (TEK);
	fprintf (pltout, "%cLP", ESC);
	ctekxypack (x, y);
	tekipack (draw_border);
	cteksetmode (VECTOR);
	poly_started = YES;
    }
    else
	ctekxypack (x, y);
}

ctekendpoly (last)
    int             last;
{
    if (!last)
	poly_started = NO;
    else
    {
	cteksetmode (TEK);
	fprintf (pltout, "%cLE", ESC);
    }
}
