/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekpack.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Tek 4105 x,y coordinate packing.
 * All x,y coordinates passed to the Tek are in this format:
 * you need not be in Vector Mode or Marker Mode to use it.
 * There are 12 significant bits per coordinate.
 * If all coordinates are multiples of 4, no 'extra' byte
 * will ever be sent. Previously-encoded positions are saved in
 * ohiy, oloy, etc. in order to abbreviate the number of
 * bytes sent out. This routine assumes pltout is open.
 */
#include	<stdio.h>
#include	"ctek.h"
extern FILE    *pltout;

ctekxypack (x, y)
{
int             hiy, extra, loy, hix, lox;
static int      ohiy, oextra, oloy, ohix;

    /*
     * Encode the new position. 
     */
    hiy = 0040 | ((y >> 7) & 037);
    loy = 0140 | ((y >> 2) & 037);
    hix = 0040 | ((x >> 7) & 037);
    lox = 0100 | ((x >> 2) & 037);
    extra = 0140 | ((y & 03) << 2) | (x & 03);

    /*
     * Only print what's necessary, according to Tek rules. 
     */
    if (hiy != ohiy)
	Putc (hiy);
    if (extra != oextra)
	Putc (extra);
    if (loy != oloy || extra != oextra || hix != ohix)
	Putc (loy);
    if (hix != ohix)
	Putc (hix);
    Putc (lox);

    /*
     * Remember these for next time. 
     */
    ohiy = hiy;
    oextra = extra;
    oloy = loy;
    ohix = hix;
}

/*
 * Issue a packed integer. From one to three bytes sent.
 */
tekipack (i)
{
int             ihi, imd, ilo;

    if (i < 0)
    {
	i = -i;
	ilo = 040;
    }
    else
	ilo = 060;

    ihi = 0100 | ((i >> 10) & 037);
    imd = 0100 | ((i >> 4) & 077);
    ilo |= (i & 017);

    if (ihi != 0100)
	Putc (ihi);
    if (imd != 0100)
	Putc (imd);
    Putc (ilo);
}

pixpack (x, n)
    int             x[];
int             n;
{
int             shift;
int             ii;
int             s;

    shift = 6 / n;
    s = 0;
    for (ii = 0; ii < n; ii++)
    {
	s = (s << shift) | (x[ii] & 7);
    }
    s += 32;
    Putc (s);
}
