/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekcolor.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include	<stdio.h>
#include	"ctek.h"

/*
 * Uses the REGIS (ugh) color mapping for the solid colors,
 * which will probably cause no end of confusion if you start
 * changing the primary colors for nicer plots.
 */

int             draw_border = 0;	/* If nonzero, draw a border on a
					 * polygon */

ctekcolor (color)
{
extern FILE    *pltout;
int             c;
/*
 * Sometimes it is hard for vplot to realize that it doesn't need to
 * change the color. It has to be safe. Here we KNOW, so we can check.
 */
static int      real_color = -1;

/*
 * Colors will always be less than num_col
 */

    c = ctekcolmap (color);

    if (c != real_color)
    {
	real_color = c;
	cteksetmode (TEK);
	fprintf (pltout, "%cML", ESC);
	tekipack (c);
    }
    return;
}
