/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Routine to close the device
 */
#include <stdio.h>
#include "ctek.h"
#include "../include/mesgcom.h"
#include "../include/closestat.h"
#include "../include/extern.h"
#include "../include/enum.h"

#define BELL	007
int             want_bell = YES;

ctekclose (status)
    int             status;
{
    switch (status)
    {
    case CLOSE_PAUSE:
	cteksetmode (ANSI);
	if (want_bell == YES)
	{
	    Putc (BELL);
	    Putc (BELL);
	    Putc (BELL);
	    Putc (BELL);
	    Putc (BELL);
	}
	break;

    case CLOSE_ERROR:
	break;

    case CLOSE_FLUSH:
	fflush (pltout);
	break;

    case CLOSE_INTERRUPT:
	Putc (US);
	fprintf (pltout, "%c%%!1", ESC);
	Putc (US);
	fprintf (pltout, "%c%%!1", ESC);
	Putc (US);
	fprintf (pltout, "%c%%!1", ESC);
	Putc (US);
	fprintf (pltout, "%c%%!1", ESC);
	cteksetmode (ANSI);
	break;

    case CLOSE_NOTHING:	/* No input */
    case CLOSE_NORMAL:
	break;

    case CLOSE_DONE:
	cteksetmode (ANSI);
	break;

    default:			/* not meant for us, ignore */
	break;
    }
}
