/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/cteklib/ctekattr.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * control graphics attributes
 */
#include <stdio.h>
#include <math.h>
#include "ctek.h"
#include "../include/attrcom.h"
extern FILE    *pltout;

ctekattributes (command, value, v1, v2, v3)
    register int    command, value;
    int             v1, v2, v3;
{
static int      cur_color;
int             color;
int             hue, lightness, saturation, temp;
float           x, y;

    switch (command)
    {
    case SET_COLOR:
	color = value;

	if ((color != cur_color) && (color >= 0))
	{
	    ctekcolor (color);
	    cur_color = color;
	}
	break;
    case SET_COLOR_TABLE:
	if (value < 8)
	{
	    x = v3 - .5 * v2 - .5 * v1;
	    y = (.866) * (v1 - v2);
	    if (x == 0. && y == 0.)
	    {
		hue = 0;
	    }
	    else
	    {
		hue = (180.) * atan2 (y, x) / 3.1416;
	    }
	    if (v1 < v2)
	    {
		temp = v1;
		v1 = v2;
		v2 = temp;
	    }
	    if (v1 < v3)
	    {
		temp = v1;
		v1 = v3;
		v3 = temp;
	    }
	    if (v2 < v3)
	    {
		temp = v2;
		v2 = v3;
		v3 = temp;
	    }
	    lightness = 100 * (v1 + v3) / (255 * 2);
	    saturation = 100 * abs (v1 - v3) / 255;
	    cteksetcoltab (value, hue, lightness, saturation);
	}
	break;
    default:
	break;
    }

    return 0;
}
