/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gigilib/gigimessage.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Device dependent subroutine to handle text operations
 * Not one of the GIGI's strong points. (Indeed if it has any)
 */
#include <stdio.h>
#include <strings.h>
#include "gigi.h"
#include "../include/mesgcom.h"

extern FILE    *pltout;

int             messagecount = 0;

gigimessage (command, string)
    int             command;
    char            string[];
{
int             count;
static int      first = 0;
    switch (command)
    {
    case MESG_OFF:
    case MESG_ON:
    case MESG_ERASE:
	break;
    case MESG_HOME:
	fprintf (pltout, ";P[0,0];");
	break;
    case MESG_READY:
	if (lastop != '\0')
	{
	    fprintf (pltout, ";P[0,0];T(BS1D0I0");
	    first = 1;
	}
	break;
    case MESG_DONE:
	if (first == 1)
	{
	    first = 0;
	    fprintf (pltout, ")");
	}
	if (lastop != '\0')
	    fprintf (pltout, "T(E);");
	break;

    case MESG_HIGHLIGHT_ON:
	fprintf (pltout, "W(A1N0I7R)");
	break;

    case MESG_HIGHLIGHT_OFF:
	gigimessage (MESG_DONE);
	gigimessage (MESG_READY);
	break;
    case MESG_TEXT:
	if (strcmp ("\n", string))
	{
	    if (first == 1)
	    {
		first = 0;
		fprintf (pltout, ")");
	    }
	    if (lastop != '\0')
	    {
		fprintf (pltout, "\"");
		for (count = messagecount; count > 0; count--)
		    fprintf (pltout, "\n");
	    }
	    fprintf (pltout, "%s", string);
	    if (lastop != '\0')
	    {
		messagecount++;
		fprintf (pltout, "\"");
	    }
	}
	break;
    }
}
