/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gigilib/gigiconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Keywords: DEC gigi pen vplot
 * DEC GIGI configuration
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"

char            name[] = "gigipen";
#include "gigidoc.h"

/*
 * device routine table structure
 */
extern int
gigiopen (), gigireset (), gigimessage (), gigierase (), gigiclose ();
extern int
genvector (), gentext (), genraster1 ();
extern int      gigiattributes ();
extern int
gigiplot (), gigistartpoly (), gigimidpoly (), gigiendpoly ();
extern int
vecarea (), genpoint (), genmarker ();
extern int
gigigetpoint (), nulldev (), geninteract ();

struct device   dev = {

 /* control routines */
		       gigiopen,	/* open */
		       gigireset,	/* reset */
		       gigimessage,	/* message */
		       gigierase,	/* erase */
		       gigiclose,	/* close */

 /* high level output */
		       genvector,	/* vector */
		       genmarker,	/* marker */
		       gentext,	/* text */
		       vecarea,	/* area */
		       genraster1,	/* raster */
		       genpoint,	/* point */
		       gigiattributes,	/* attributes */

 /* input */
		       gigigetpoint,	/* getpoint */
		       geninteract,	/* interact */

 /* low level output */
		       gigiplot,	/* plot */
		       nulldev,	/* startpoly */
		       nulldev,	/* midpoly */
		       nulldev	/* endpoly */
};
