/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gigilib/gigiclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Routine to finish up with the terminal.
 */
#include <stdio.h>
#include "gigi.h"
#include "../include/closestat.h"
#include "../include/mesgcom.h"
extern FILE    *pltout;

gigiclose (status)
    int             status;
{
    switch (status)
    {
    case CLOSE_DONE:
	if (lastop != '\0')
	    goff ();
	break;
    case CLOSE_FLUSH:
	fflush (pltout);
	break;
    case CLOSE_PAUSE:
	gigimessage (MESG_HOME);
	break;
    case CLOSE_INTERRUPT:
	if (lastop != '\0')
	{
	    fprintf (pltout, ";;;");
	}
	break;
    case CLOSE_NORMAL:
    case CLOSE_ERROR:
    case CLOSE_NOTHING:
    default:			/* not meant for us, ignore */
	break;
    }
}

extern char    *getenv ();
goff ()
{
    /* GIGI owners manual page 66 */
static char     off1[10] = "X\\";
char           *screencolor;
    off1[0] = ESC;
    if (NULL != (screencolor = getenv ("SCREEN")))
	fprintf (pltout, ";S(I(%c))", *screencolor);
    fprintf (pltout, "%s", off1);
    fflush (pltout);
    lastop = ' ';
}
