/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/gigilib/gigiattr.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * control graphics attributes
 */
#include <stdio.h>
#include "gigi.h"
#include "../include/attrcom.h"
extern FILE    *pltout;
extern char     wstype[], callname[];

gigiattributes (command, value, dummy1, dummy2, dummy3)
    int             command, value, dummy1, dummy2, dummy3;
{
static int      cur_color;
int             color;

    switch (command)
    {
    case SET_COLOR:
	if ((!strcmp (wstype, "vt125")) && (value > 3))
	    color = 1 + (value - 2) % 3;	/* this maps 7 (white) to 3
						 * (white) */
	else
	if (value > 7)
	    color = 1 + (value - 8) % 7;
	else
	    color = value;

	if ((color != cur_color) && (color >= 0))
	{
	    if (color == 0)
		fprintf (pltout, ";@:W (W(EI%dA0N0M2P1(M2)))@;", color);
	    else
		fprintf (pltout, ";@:W (W(VI%dA0N0M2P1(M2)))@;", color);
	    lastop = ' ';
	    cur_color = color;
	}
	break;
    case SET_COLOR_TABLE:	/* None to set on GIGI */
	break;
    default:
	break;
    }

    return 0;
}
