/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/rteklib/rtekutil.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/* utilities for sending Raster Tech commands */
#include "rtekpen.h"

/* be sure that a command string has an even byte count; add a NOP */
byte (arg)
    char            arg;
{
    fputc (arg & 0xFF, rtekfd);
}

word (arg)
    short           arg;
{
    fputc ((arg & 0xFF00) >> 8, rtekfd);
    fputc (arg & 0xFF, rtekfd);
}

rtek_flsbuf (len)
    int             len;
{
int             newlen;
extern char    *malloc ();

    if (rtekfd->_cnt & 1)	/* odd byte count left in stdio buffer */
	byte (NOP);		/* pad to even length */
    fflush (rtekfd);

    /* now check if there's enough buffer space after flushing */
    if (len > rtekfd->_bufsiz)
    {				/* expand buffer */
	free (rtekfd->_base);
	newlen = len + (len & 1);
	rtekfd->_base = malloc (newlen);
	rtekfd->_ptr = rtekfd->_base;
	rtekfd->_bufsiz = newlen;
	rtekfd->_cnt = newlen;
    }
}
