/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/rteklib/rtekraster.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include "rtekpen.h"

/* Revised  4/19/87  Stewart A. Levin   SEP   added direct raster
 *                                            for all orients
 *
 *  For orient=1, simply switch nrows and ncols from orient=0
 *  For orient=2, reverse raster line in core and write it out
 *  For orient=3, same method as orient=2.  Code also left in
 *                to use rtek internal pixel functions to reverse
 *                within the display using 3 XOR's.  This is not
 *                invoked on the Convex because it's slower.
 *
 * Joe Dellinger 6/12/87 need to set lost=YES after raster.
 * Joe Dellinger Feb 16 1988
 *	Update to new order of arguments for dumb raster.
 */
extern int      genraster ();
extern int      lost;

rtekraster (count, out_of, xpos, ypos, length, orient, raster, dummy1, dummy2)
    int             count, out_of, xpos, ypos, length, orient, dummy1, dummy2;
    char           *raster;
{
int             hlen;
register char  *ptr;

    switch (orient)
    {
    case 0:
	rtekplot (xpos, ypos, 0);
	CHKLEN (5 + length);
	byte (PIXEL8);		/* cmdlen = 5 + length */
	word (1);
	word (length);
	fwrite (raster, 1, length, rtekfd);
	break;
    case 1:
	rtekplot (xpos, ypos, 0);
	CHKLEN (5 + length);
	byte (PIXEL8);		/* cmdlen = 5 + length */
	word (length);
	word (1);
	fwrite (raster, 1, length, rtekfd);
	break;
    case 2:
	rtekplot (xpos - length + 1, ypos, 0);
	CHKLEN (5 + length);
	byte (PIXEL8);
	word (1);
	word (length);
	for (ptr = raster + length - 1; ptr >= raster; ptr--)
	    putc (*ptr, rtekfd);
	break;
    case 3:
	rtekplot (xpos, ypos + length - 1, 0);
	CHKLEN (5 + length);
	byte (PIXEL8);
	word (length);
	word (1);
	for (ptr = raster + length - 1; ptr >= raster; ptr--)
	    putc (*ptr, rtekfd);
#ifdef undef
	/* this reverses rasters inside device */
	hlen = length >> 1;
	rtekplot (xpos, ypos + length - 1, 0);
	CHKLEN (5 + length);	/* load rasters backwards */
	byte (PIXEL8);
	word (length);
	word (1);
	fwrite (raster, 1, length, rtekfd);
	CHKLEN (2);		/* set to XOR pixel mode */
	byte (PIXFUN);
	byte (4);
	CHKLEN (6);		/* define 2 half-length windows */
	byte (CLOAD);
	byte (11);
	word (xpos);
	word (ypos);
	CHKLEN (6);
	byte (CLOAD);
	byte (12);
	word (xpos);
	word (ypos + hlen - 1);
	CHKLEN (6);
	byte (CLOAD);
	byte (13);
	word (xpos);
	word (ypos + length - 1);
	CHKLEN (6);
	byte (CLOAD);
	byte (14);
	word (xpos);
	word (ypos + length - hlen);
	CHKLEN (1);
	byte (PIXMOV);		/* perform XOR number 1 */
	CHKLEN (3);
	byte (CMOVE);
	byte (11);
	byte (13);
	CHKLEN (3);
	byte (CMOVE);
	byte (12);
	byte (14);
	CHKLEN (6);
	byte (CLOAD);
	byte (13);
	word (xpos);
	word (ypos);
	CHKLEN (6);
	byte (CLOAD);
	byte (14);
	word (xpos);
	word (ypos + hlen - 1);
	CHKLEN (1);
	byte (PIXMOV);
	CHKLEN (3);
	byte (CMOVE);
	byte (13);
	byte (11);
	CHKLEN (3);
	byte (CMOVE);
	byte (14);
	byte (12);
	CHKLEN (6);
	byte (CLOAD);
	byte (11);
	word (xpos);
	word (ypos);
	CHKLEN (6);
	byte (CLOAD);
	byte (12);
	word (xpos);
	word (ypos + hlen - 1);
	CHKLEN (1);
	byte (PIXMOV);
	CHKLEN (2);
	byte (PIXFUN);		/* reset pixel to insert mode */
	byte (0);
#endif undef
	break;
    default:			/* this shouldn't happen */
	genraster (count, out_of, xpos, ypos, length, orient, raster, 0, 0);
	break;
    }
    lost = 1;
}
