/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/rteklib/rtekopen.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 * Joe Dellinger Feb 12 1988
 *	Initial color should be white not blue!
 * Joe Dellinger Mar 3 1988
 *	Get device file name in /dev out of include file.
 */

#include "rtekpen.h"
#ifdef SEP
#define	GETPAR fetch
#else
#define	GETPAR getpar
#endif

#include "../include/attrcom.h"
#include "../include/params.h"

FILE           *rtekfd = NULL;
char            devname[] = RTEKDEV;
extern int      allowecho;

rtekopen ()
{
int             bufsize;
char            block[10], *buffer;

    dev_xmax = 635;
    dev_ymax = 507;
    dev_xmin = -635;
    dev_ymin = -507;
    pixels_per_inch = 100.;
    aspect_ratio = 1.;

    /* device capabilities */
    need_end_erase = YES;
    buffer_output = NO;
    smart_clip = YES;
    num_col = 256;

    /* make pen leave our echoing alone */
    allowecho = YES;

    /* fast device, so default a nice font */
    txfont = DEFAULT_HARDCOPY_FONT;
    txprec = DEFAULT_HARDCOPY_PREC;

    /* open dma channel to Raster Tech */
    rtekfd = fopen (devname, "w");
    if (rtekfd == NULL)
	ERR (FATAL, name, "can't open Raster Tech\n");

    /* setup buffer */
    GETPAR ("block", "s", block);
    switch (block[0])
    {
    case 'l':
    case 'b':
    case 'h':
	bufsize = 100000;
	break;
    case 's':
	bufsize = 16;
	break;
    case 'm':
    default:
	bufsize = 512;
	break;
    }
    bufsize &= ~1;		/* make sure it is even */
    buffer = (char *) malloc (bufsize);
    setbuffer (rtekfd, buffer, bufsize);

    /* set graphics mode, undo any Movie remnants */

    CHKLEN (26);
    byte (GRAPHICS);		/* cmdlen = 26 */
    byte (NOP);
    byte (RDMODE);
    byte (1);
    byte (MODDIS);
    byte (2);
    byte (NOP);
    byte (ZOOM);
    byte (1);
    byte (SCRORG);
    word (0);
    word (0);
    byte (WINDOW);
    word (dev_xmin);
    word (dev_ymin);
    word (dev_xmax);
    word (dev_ymax);
    byte (WMSK16);
    word (65535);

    /* initialize color */
    rtekattributes (SET_COLOR_TABLE, 0, 0, 0, 0);
    rtekattributes (SET_COLOR_TABLE, 1, 0, 0, 255);
    rtekattributes (SET_COLOR_TABLE, 2, 255, 0, 0);
    rtekattributes (SET_COLOR_TABLE, 3, 255, 0, 255);
    rtekattributes (SET_COLOR_TABLE, 4, 0, 255, 0);
    rtekattributes (SET_COLOR_TABLE, 5, 0, 255, 255);
    rtekattributes (SET_COLOR_TABLE, 6, 255, 255, 0);
    rtekattributes (SET_COLOR_TABLE, 7, 255, 255, 255);
    rtekattributes (SET_COLOR, 7, 0, 0, 0);
}
