/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/rteklib/rtekconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include "rtekpen.h"

/* declarations */
#ifdef SEP
char            name[] = "Rpen";
#else
char            name[] = "rpen";
#endif
#include "rtekdoc.h"

/* physical device size */
int             version = 1 - 75;

/* device routine table */
extern
rtekopen (), rtekclose (), rtekplot (), rtekerase (), rtekattributes ();
extern
rtekpoint (), rtekarea (), rtekraster (), rtekgetpoint ();
extern
nulldev (), genmessage (), genvector (), genmarker (), gentext ();
extern
vecarea (), genpatarea (), geninteract ();

struct device   dev = {
 /* control routines */
		       rtekopen,	/* open */
		       nulldev,	/* reset */
		       genmessage,	/* message */
		       rtekerase,	/* erase */
		       rtekclose,	/* close */
 /* high level output */
		       genvector,	/* vector */
		       genmarker,	/* marker */
		       gentext,	/* text */
		       genpatarea,	/* area */
		       rtekraster,	/* raster */
		       rtekpoint,	/* point */
		       rtekattributes,	/* attributes */
 /* input */
		       rtekgetpoint,	/* getpoint */
		       geninteract,	/* interact */
 /* low level output */
		       rtekplot,	/* plot */
		       nulldev,	/* startpoly */
		       nulldev,	/* midpoly */
		       nulldev	/* endpoly */
};
