/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/lprlib/lpropen.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/err.h"
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/params.h"
#include "lprpen.h"

/* raster memory */
short          *mem;	/* front of bit map */
int             xlimit = XSTRSZ;
char            inbuf[BUFSIZ];	/* input buffer -used by getc/h */
short           line[NYW + 1];	/* buffer for one raster line */

int             file_created = NO;
char            spoolfile[100];
char            mapfile[100] = "default";

lpropen ()
{
/*
 * physical device parameters
 */
    dev_xmax = 3000;
    dev_ymax = 791;
    dev_xmin = 0;
    dev_ymin = 0;
    pixels_per_inch = 72.0;
    aspect_ratio = 1.2023;
    num_col = 0;

/*
 * device capabilities
 */
    need_end_erase = YES;
    buffer_output = YES;
    smart_clip = NO;
    mono = YES;
    dither = 3;
    pixc = 0.6;
    greyc = -0.5;

/* Since this is a hard copy device, might as well use a nice font */
    txfont = DEFAULT_HARDCOPY_FONT;
    txprec = DEFAULT_HARDCOPY_PREC;

    epause = 0;
    endpause = NO;
    size = ABSOLUTE;
    if (isatty (fileno (pltout)))
    {
	file_created = YES;
	sprintf (spoolfile, "%s%s", LPR_SPOOL, "/lprpen_XXXXXX");
	mktemp (spoolfile);
	pltout = fopen (spoolfile, "w");
	if (pltout == NULL)
	{
	    ERR (FATAL, name, "could not open spool file %s!",
		 spoolfile);
	}
    }

    mem = (short *) malloc (2 * XSTRSZ * NYW);
}
