/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/lprlib/lprerase.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Erase the graphics area (ie output raster image and clear memory)
 */
#include <stdio.h>
#include "lprpen.h"
#include "../include/enum.h"
#include "../include/erasecom.h"
#include "../include/extern.h"

lprerase (command)
    int             command;
{
    switch (command)
    {
    case ERASE_MIDDLE:
    case ERASE_END:
	cat ();
	zap (mem, xlimit);
    case ERASE_START:
    default:
	break;
    }
}


#define M	0100	/* mask bit for printronix */
char            rev[] =	/* bit reverse table for Printronix format */
{
 (000 | M), (040 | M), (020 | M), (060 | M), (010 | M), (050 | M), (030 | M), (070 | M),
 (004 | M), (044 | M), (024 | M), (064 | M), (014 | M), (054 | M), (034 | M), (074 | M),
 (002 | M), (042 | M), (022 | M), (062 | M), (012 | M), (052 | M), (032 | M), (072 | M),
 (006 | M), (046 | M), (026 | M), (066 | M), (016 | M), (056 | M), (036 | M), (076 | M),
 (001 | M), (041 | M), (021 | M), (061 | M), (011 | M), (051 | M), (031 | M), (071 | M),
 (005 | M), (045 | M), (025 | M), (065 | M), (015 | M), (055 | M), (035 | M), (075 | M),
 (003 | M), (043 | M), (023 | M), (063 | M), (013 | M), (053 | M), (033 | M), (073 | M),
 (007 | M), (047 | M), (027 | M), (067 | M), (017 | M), (057 | M), (037 | M), (077 | M)
};
#define PUT(x)	putc(prev[x], pltout)

cat ()
{
register short *p1, *p2;
register char  *prev;
register int    len;
int             x, xmax, count, addr;

    prev = rev;

    for (p2 = &mem[xlimit * NYW - 1]; p2 >= mem && *p2 == 0; p2--);
    xmax = (p2 - mem) / NYW + 1;
    for (x = 0; x < xmax; x++)
    {
	p1 = mem + x * NYW;
	p2 = p1 + (NYW - 1);
	while (p2 >= p1 && *p2 == 0)
	    p2--;
	if (*p2 == 0)
	    len = 0;
	else
	    len = (16 * (p2 - p1 + 1) + 5) / 6;
	if (len > 132)
	    len = 132;
	putc (05, pltout);
	while (len > 0)
	{
	    PUT ((p1[0] >> 10) & 077);
	    PUT ((p1[0] >> 4) & 077);
	    PUT ((p1[0] << 2) & 074 | (p1[1] >> 14) & 03);
	    PUT ((p1[1] >> 8) & 077);

	    if (len == 4)
		break;
	    PUT ((p1[1] >> 2) & 077);
	    PUT ((p1[1] << 4) & 060 | (p1[2] >> 12) & 017);
	    PUT ((p1[2] >> 6) & 077);
	    PUT ((p1[2]) & 077);
	    p1 += 3;
	    len -= 8;
	}
	putc ('\n', pltout);
    }
    putc ('\f', pltout);
    return;
}

zap (addr, nx)		/* zero memory */
    register int   *addr, nx;
{
register int    count;
    count = nx * NYW / 2;
    while (count--)
	*addr++ = 0;
}
