/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/lprlib/lprconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * printronix P300/P600 configuration
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"

/*
 * mandatory declarations and initializations
 */
#ifdef SEP
char            name[] = "Lprpen";
#else
char            name[] = "lprpen";
#endif
#include "lprdoc.h"

/*
 * device routine table
 */
extern int
lpropen (), lprerase (), lprclose (), lprvector ();
extern int
gentext (), genraster (), genmessage (), genpatarea ();
extern int
genpoint (), genmarker (), lprattr (), nulldev ();

struct device   dev = {

 /* control routines */
		       lpropen,	/* open */
		       nulldev,	/* reset */
		       genmessage,	/* message */
		       lprerase,	/* erase */
		       lprclose,	/* close */

 /* high level output */
		       lprvector,	/* vector */
		       genmarker,	/* marker */
		       gentext,	/* text */
		       genpatarea,	/* area */
		       genraster,	/* raster */
		       genpoint,	/* point */
		       lprattr,	/* attributes */

 /* input */
		       nulldev,	/* getpoint */
		       nulldev,	/* interact */

 /* low level output */
		       nulldev,	/* plot */
		       nulldev,	/* startpoly */
		       nulldev,	/* midpoly */
		       nulldev	/* endpoly */
};
