/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/lprlib/lprclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/* Routine to finish up */
#include <stdio.h>
#include "../include/closestat.h"
#include "../include/enum.h"
#include "../include/extern.h"
#include "lprpen.h"

lprclose (status)
    int             status;
{
char            system_call[120];

    switch (status)
    {
    case CLOSE_NORMAL:
	if (file_created)
	{
	    fclose (pltout);
	    sprintf (system_call, "lpr -l  %s\n", spoolfile);
	    system (system_call);
	}
	break;
    case CLOSE_FLUSH:
	fflush (pltout);
	break;
    case CLOSE_ERROR:
    case CLOSE_NOTHING:
    case CLOSE_INTERRUPT:
	break;
    case CLOSE_DONE:
	/*
	 * If we created a temporary file, remove it 
	 */
	if (file_created)
	    unlink (spoolfile);
	break;
    case CLOSE_PAUSE:
	break;
    default:			/* not meant for us, ignore */
	break;
    }
}
