/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagplot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/err.h"
#include "../include/enum.h"
#include "../include/extern.h"
#include "imagen.h"

/*
 * PATCH:
 * Occasionally, the imagen will forget to plot the last segment of
 * a path. To guard against this, the last point of each path is
 * repeated!
 */
int             lost = 1;

imagplot (x, y, draw)
    int             x, y, draw;
{
    if (draw == 0)
    {
	startpath ();
	lost = 0;
    }
    addpath (x, y);
}

static int      pathsave[PATHLENGTH][2];
static int      where = -1;

startpath ()
{
    if (where > 0)
    {
	endpath (DRAW_PATH, imag_curcolor);
    }
    where = 0;
}

addpath (x, y)
    int             x, y;
{
static int      oldx, oldy;

    if (where == -1)
	ERR (FATAL, name,
	     "addpath, with no active path!(This can't happen.)");
    if (where > 0 && x == oldx && y == oldy)
	return;
    pathsave[where][1] = x;	/* The default coordinates are pretty bizarre */
    pathsave[where][0] = y;	/* Swap X and Y and they look standard! */
    oldx = x;
    oldy = y;
    where++;

    /*
     * PATCH: leave room for redundant point at end 
     */
    if (where == PATHLENGTH - 1)
    {
	endpath (DRAW_PATH, imag_curcolor);
    }
}

endpath (what_to_do, what_color)
    int             what_to_do, what_color;
{
int             i;

    if (where == 0)
	ERR (FATAL, name, "endpath, can't end path with length zero");

    /*
     * PATCH: Add redundant point at end 
     */
    if (where > 0)
    {
	pathsave[where][0] = pathsave[where - 1][0];
	pathsave[where][1] = pathsave[where - 1][1];
	where++;

	fprintf (pltout, "%c%c%c", CREATE_PATH, hib (where), lob (where));
	for (i = 0; i < where; i++)
	{
	    fprintf (pltout, "%c%c", hib (pathsave[i][0]), lob (pathsave[i][0]));
	    fprintf (pltout, "%c%c", hib (pathsave[i][1]), lob (pathsave[i][1]));
	}
	fprintf (pltout, "%c%c", what_to_do, what_color);
	where = -1;
    }
    lost = 1;
}
