/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagerase.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Erase the graphics area (ie issue an ENDPAGE after cleanup)
 */
#include <stdio.h>
#include "imagen.h"
#include "../include/enum.h"
#include "../include/erasecom.h"
#include "../include/extern.h"

#define BOX_HEIGHT 60
#define BOX_Y_POS  75
#define CHAR_WIDTH  30
#define INCHES_FROM_LEFT  .7

imagerase (command)
    int             command;
{
register int    i, ii;
static int      page_count = 1;
char            full_label[100];
int             box_length, box_start;

    switch (command)
    {
    case ERASE_MIDDLE:
    case ERASE_END:
	endpath (DRAW_PATH, imag_curcolor);

	/*
	 * Put on label, if desired 
	 */
	if (label[0] != '\0')
	{
	    if (page_count == 1 && command == ERASE_END)
	    {
		sprintf (full_label, "%s", label);
	    }
	    else
	    {
		sprintf (full_label, "%s : Page %d.", label, page_count);
	    }
	    for (i = 0; i < 60 && full_label[i] != '\0'; i++);
	    box_length = (i + 1) * CHAR_WIDTH;
	    box_start = dev_xmax - INCHES_FROM_LEFT * 300 - box_length;
	    dev.plot (box_start, BOX_Y_POS, 0);
	    dev.plot (box_start, BOX_Y_POS + BOX_HEIGHT, 1);
	    dev.plot (box_start + box_length, BOX_Y_POS + BOX_HEIGHT, 1);
	    dev.plot (box_start + box_length, BOX_Y_POS, 1);
	    endpath (FILL_PATH, WHITE);
	    fprintf (pltout, "%c%c", SET_ADV_DIRS, '\002');
	    fprintf (pltout, "%c%c", SET_FAMILY, '\002');
	    fprintf (pltout, "%c%c%c",
		     SET_SP, hib (CHAR_WIDTH), lob (CHAR_WIDTH));
	    fprintf (pltout, "%c", SET_ABS_V);
	    fprintf (pltout, "%c%c", hib (box_start + CHAR_WIDTH / 2),
		     lob (box_start + CHAR_WIDTH / 2));
	    fprintf (pltout, "%c", SET_ABS_H);
	    fprintf (pltout, "%c%c", hib (BOX_Y_POS + CHAR_WIDTH / 2),
		     lob (BOX_Y_POS + CHAR_WIDTH / 2));
	    for (ii = 0; ii < i; ii++)
	    {
		if (full_label[ii] != ' ')
		{
		    fprintf (pltout, "%c", full_label[ii]);
		}
		else
		{
		    fprintf (pltout, "%c", SP);
		}
	    }
	}
	if (!stripped)
	{
	    fprintf (pltout, "%c", ENDPAGE);
	}
	page_count++;
	break;
    case ERASE_START:
    default:
	break;
    }
}
