/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagconf.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/*
 * Imagen 8/300 configuration
 * Keyword: vplot imagen pen
 */
#include <stdio.h>
#include "../include/enum.h"
#include "../include/extern.h"

/*
 * mandatory declarations and initializations
 */
#ifdef SEP
char            name[] = "Imagpen";
#else
char            name[] = "imagpen";
#endif
#include "imagdoc.h"

/*
 * device routine table
 */
extern int
imagopen (), imagreset (), imagerase (), imagclose ();
extern int
imagvector (), imagplot (), imagattributes ();
extern int
gentext (), imagraster (), genmessage (), hersheytext ();
extern int
genarea (), genmarker (), genpoint ();
extern int
nulldev (), imagstartpoly (), imagmidpoly (), imagendpoly ();

struct device   dev =
{

 /* control routines */
 imagopen,		/* open */
 imagreset,		/* reset */
 genmessage,		/* message */
 imagerase,		/* erase */
 imagclose,		/* close */

 /* high level output */
 imagvector,		/* vector */
 genmarker,		/* marker */
 gentext,		/* text */
 genarea,		/* area */
 imagraster,		/* raster */
 genpoint,		/* point */
 imagattributes,	/* attributes */

 /* input */
 nulldev,		/* getpoint */
 nulldev,		/* interact */

 /* low level output */
 imagplot,		/* plot */
 imagstartpoly,		/* startpoly */
 imagmidpoly,		/* midpoly */
 imagendpoly		/* endpoly */
};
