/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/imaglib/imagclose.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/* Routine to finish up */
#include <stdio.h>
#include "../include/closestat.h"
#include "../include/enum.h"
#include "../include/extern.h"
#include "../include/err.h"
#include "imagen.h"

imagclose (status)
    int             status;
{
char            system_call[120];
extern int      system ();

    switch (status)
    {
    case CLOSE_FLUSH:
	fflush (pltout);
	break;
    case CLOSE_NORMAL:
	if (tex == YES)
	    fprintf (pltout, "%c", POP);
	if (stripped == NO)
	    fprintf (pltout, "%c", EOPLOT);
	/*
	 * If we created a temporary file, ipr it and tell it to remove it
	 * when done. 
	 */
	if (file_created)
	{
	    fclose (pltout);
	    sprintf (system_call, "lpr -Pim -r -s -v %s\n", scratch_file);
	    if (0 == system (system_call))
	    {
		file_created = NO;
	    }
	    else
	    {
		/* else figure we'll need to delete scratch file outselves */
		ERR (WARN, name, "Couldn't get lpr to cooperate\n");
	    }
	}
	break;
    case CLOSE_ERROR:
    case CLOSE_NOTHING:
    case CLOSE_INTERRUPT:
	break;
    case CLOSE_DONE:
	/*
	 * If we created a temporary file, remove it 
	 */
	if (file_created)
	    unlink (scratch_file);
	break;
    case CLOSE_PAUSE:
	break;
    default:			/* not meant for us, ignore */
	break;
    }
}
