/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/enviplot.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "envi.h"
extern FILE    *pltout;

int             lost = 1;	/* 1 means we are lost, zero means we aren't */

enviplot (x, y, draw)	/* efficiently get to the point x,y. */
    int             x, y, draw;	/* draw 0 means we want to move, not to draw */
{
int             hiy, loy, hix, lox;
int             ok;	/* ok not 1 means that our old position is
			 * meaningless */
static int      ohiy, oloy, ohix, olox;

    if (draw == 0)
    {
	envisetmode (REG);
    }
    envisetmode (TEK);

    ok = (lost == 0);
    hiy = (y >> 5) | 040;	/* y/32+32 hi y byte */
    loy = (y & 037) | 0140;	/* y%32+96 low y byte */
    hix = (x >> 5) | 040;	/* x/32+32 hi x byte */
    lox = (x & 037) | 0100;	/* x%32+64 low x byte */

    if ((hiy != ohiy) || (ok != 1))
	fprintf (pltout, "%c", hiy);
    if ((hix != ohix) || (ok != 1))
    {
	fprintf (pltout, "%c%c", loy, hix);
    }
    else
    {
	if ((loy != oloy) || (ok != 1))
	    fprintf (pltout, "%c", loy);
    }
    fprintf (pltout, "%c", lox);

    /* remember this for next time */
    oloy = loy;
    ohiy = hiy;
    ohix = hix;
    olox = lox;

    lost = 0;
}
