/*
 * Copyright 1987 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of my example below.
 */

/*
 *
 *  source file:   ./filters/envilib/envimessage.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

#include <stdio.h>
#include "../include/mesgcom.h"
#include "envi.h"
extern FILE    *pltout;

envimessage (command, string)
    int             command;
    char            string[];
{
    switch (command)
    {
    case MESG_OFF:		/* Turn off Text */
	envisetmode (REG);	/* Get out of Tek mode */
	fprintf (pltout, "%cRA0", ESC);
	fflush (pltout);
	break;
    case MESG_ON:		/* Turn on Text */
	envisetmode (REG);	/* Get out of Tek mode */
	fprintf (pltout, "%cRA1", ESC);
	fflush (pltout);
	break;
    case MESG_ERASE:		/* Erase Text */
	envisetmode (REG);	/* Get out of Tek mode */
	putc (ESC, pltout);
	fprintf (pltout, "[2J");/* Erase Text Screen */
	fflush (pltout);
	break;
    case MESG_HOME:		/* Home */
	envisetmode (REG);	/* Get out of Tek mode */
	fprintf (pltout, "%c[H", ESC);	/* Home */
	break;
    case MESG_READY:		/* Prepare for text */
	envisetmode (REG);	/* Get out of Tek mode */
	enviresetpan ();	/* Need to print on the text screen */
	fflush (pltout);
	break;
    case MESG_DONE:		/* Done with text */
	envisetpan ();
	fflush (pltout);
	break;
    case MESG_HIGHLIGHT_ON:	/* Get ready for prompting */
	fprintf (pltout, "%c[5m", ESC);
	break;
    case MESG_HIGHLIGHT_OFF:	/* Get ready for prompting */
	fprintf (pltout, "%c[0m", ESC);
	break;
    case MESG_TEXT:		/* Print out the text */
	fprintf (pltout, "%s", string);
	break;
    default:			/* Not intended for us, ignore */
	break;
    }
}
